/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.event;

import com.hotels.bdp.circustrain.api.event.CopierListener;
import com.hotels.bdp.circustrain.api.metrics.Metrics;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeCopierListener
implements CopierListener {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeCopierListener.class);
    private final List<CopierListener> listeners;

    public CompositeCopierListener(List<CopierListener> listeners) {
        this.listeners = Collections.unmodifiableList(listeners);
    }

    public void copierStart(String copierImplementation) {
        for (CopierListener listener : this.listeners) {
            try {
                listener.copierStart(copierImplementation);
            }
            catch (Exception e) {
                LOG.error("Listener '{}' threw exception on copierStart.", (Object)listener, (Object)e);
            }
        }
    }

    public void copierEnd(Metrics metrics) {
        for (CopierListener listener : this.listeners) {
            try {
                listener.copierEnd(metrics);
            }
            catch (Exception e) {
                LOG.error("Listener '{}' threw exception on copierEnd.", (Object)listener, (Object)e);
            }
        }
    }
}

