/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.event;

import com.hotels.bdp.circustrain.api.CompletionCode;
import com.hotels.bdp.circustrain.api.event.EventReplicaCatalog;
import com.hotels.bdp.circustrain.api.event.EventSourceCatalog;
import com.hotels.bdp.circustrain.api.event.LocomotiveListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeLocomotiveListener
implements LocomotiveListener {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeLocomotiveListener.class);
    private final List<LocomotiveListener> listeners;

    public CompositeLocomotiveListener(List<LocomotiveListener> listeners) {
        this.listeners = Collections.unmodifiableList(listeners);
    }

    public void circusTrainStartUp(String[] args, EventSourceCatalog sourceCatalog, EventReplicaCatalog replicaCatalog) {
        for (LocomotiveListener listener : this.listeners) {
            try {
                listener.circusTrainStartUp(args, sourceCatalog, replicaCatalog);
            }
            catch (Exception e) {
                LOG.error("Listener '{}' threw exception on circusTrainStartUp.", (Object)listener, (Object)e);
            }
        }
    }

    public void circusTrainShutDown(CompletionCode completionCode, Map<String, Long> metrics) {
        for (LocomotiveListener listener : this.listeners) {
            try {
                listener.circusTrainShutDown(completionCode, metrics);
            }
            catch (Exception e) {
                LOG.error("Listener '{}' threw exception on circusTrainShutDown.", (Object)listener, (Object)e);
            }
        }
    }
}

