/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.event;

import com.hotels.bdp.circustrain.api.event.EventPartitions;
import com.hotels.bdp.circustrain.api.event.ReplicaCatalogListener;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeReplicaCatalogListener
implements ReplicaCatalogListener {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeReplicaCatalogListener.class);
    private final List<ReplicaCatalogListener> listeners;

    public CompositeReplicaCatalogListener(List<ReplicaCatalogListener> listeners) {
        this.listeners = Collections.unmodifiableList(listeners);
    }

    public void resolvedReplicaLocation(URI location) {
        for (ReplicaCatalogListener listener : this.listeners) {
            try {
                listener.resolvedReplicaLocation(location);
            }
            catch (Exception e) {
                LOG.error("Listener '{}' threw exception on resolvedReplicaLocation.", (Object)listener, (Object)e);
            }
        }
    }

    public void existingReplicaPartitions(EventPartitions partitions) {
        for (ReplicaCatalogListener listener : this.listeners) {
            try {
                listener.existingReplicaPartitions(partitions);
            }
            catch (Exception e) {
                LOG.error("Listener '{}' threw exception on existingReplicaPartitions.", (Object)listener, (Object)e);
            }
        }
    }

    public void partitionsToCreate(EventPartitions partitions) {
        for (ReplicaCatalogListener listener : this.listeners) {
            try {
                listener.partitionsToCreate(partitions);
            }
            catch (Exception e) {
                LOG.error("Listener '{}' threw exception on partitionsToCreate.", (Object)listener, (Object)e);
            }
        }
    }

    public void partitionsToAlter(EventPartitions partitions) {
        for (ReplicaCatalogListener listener : this.listeners) {
            try {
                listener.partitionsToAlter(partitions);
            }
            catch (Exception e) {
                LOG.error("Listener '{}' threw exception on partitionsToAlter.", (Object)listener, (Object)e);
            }
        }
    }

    public void deprecatedReplicaLocations(List<URI> locations) {
        for (ReplicaCatalogListener listener : this.listeners) {
            try {
                listener.deprecatedReplicaLocations(locations);
            }
            catch (Exception e) {
                LOG.error("Listener '{}' threw exception on deprecatedReplicaLocations.", (Object)listener, (Object)e);
            }
        }
    }
}

