/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.event;

import com.hotels.bdp.circustrain.api.event.EventPartitions;
import com.hotels.bdp.circustrain.api.event.EventTable;
import com.hotels.bdp.circustrain.api.event.SourceCatalogListener;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeSourceCatalogListener
implements SourceCatalogListener {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeSourceCatalogListener.class);
    private final List<SourceCatalogListener> listeners;

    public CompositeSourceCatalogListener(List<SourceCatalogListener> listeners) {
        this.listeners = Collections.unmodifiableList(listeners);
    }

    public void resolvedMetaStoreSourceTable(EventTable table) {
        for (SourceCatalogListener listener : this.listeners) {
            try {
                listener.resolvedMetaStoreSourceTable(table);
            }
            catch (Exception e) {
                LOG.error("Listener '{}' threw exception on resolvedMetaStoreSourceTable.", (Object)listener, (Object)e);
            }
        }
    }

    public void resolvedSourcePartitions(EventPartitions partitions) {
        for (SourceCatalogListener listener : this.listeners) {
            try {
                listener.resolvedSourcePartitions(partitions);
            }
            catch (Exception e) {
                LOG.error("Listener '{}' threw exception on resolvedSourcePartitions.", (Object)listener, (Object)e);
            }
        }
    }

    public void resolvedSourceLocation(URI location) {
        for (SourceCatalogListener listener : this.listeners) {
            try {
                listener.resolvedSourceLocation(location);
            }
            catch (Exception e) {
                LOG.error("Listener '{}' threw exception on resolvedSourceLocation.", (Object)listener, (Object)e);
            }
        }
    }
}

