/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.event;

import com.hotels.bdp.circustrain.api.event.EventTableReplication;
import com.hotels.bdp.circustrain.api.event.TableReplicationListener;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeTableReplicationListener
implements TableReplicationListener {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeTableReplicationListener.class);
    private final List<TableReplicationListener> listeners;

    public CompositeTableReplicationListener(List<TableReplicationListener> listeners) {
        this.listeners = Collections.unmodifiableList(listeners);
    }

    public void tableReplicationStart(EventTableReplication tableReplication, String eventId) {
        for (TableReplicationListener listener : this.listeners) {
            try {
                listener.tableReplicationStart(tableReplication, eventId);
            }
            catch (Exception e) {
                LOG.error("Listener '{}' threw exception on tableReplicationStart.", (Object)listener, (Object)e);
            }
        }
    }

    public void tableReplicationSuccess(EventTableReplication tableReplication, String eventId) {
        for (TableReplicationListener listener : this.listeners) {
            try {
                listener.tableReplicationSuccess(tableReplication, eventId);
            }
            catch (Exception e) {
                LOG.error("Listener '{}' threw exception on tableReplicationSuccess.", (Object)listener, (Object)e);
            }
        }
    }

    public void tableReplicationFailure(EventTableReplication tableReplication, String eventId, Throwable t) {
        for (TableReplicationListener listener : this.listeners) {
            try {
                listener.tableReplicationFailure(tableReplication, eventId, t);
            }
            catch (Exception e) {
                LOG.error("Listener '{}' threw exception on tableReplicationFailure.", (Object)listener, (Object)e);
            }
        }
    }
}

