/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.event;

import com.hotels.bdp.circustrain.api.CompletionCode;
import com.hotels.bdp.circustrain.api.event.CopierListener;
import com.hotels.bdp.circustrain.api.event.EventPartitions;
import com.hotels.bdp.circustrain.api.event.EventReplicaCatalog;
import com.hotels.bdp.circustrain.api.event.EventSourceCatalog;
import com.hotels.bdp.circustrain.api.event.EventTable;
import com.hotels.bdp.circustrain.api.event.EventTableReplication;
import com.hotels.bdp.circustrain.api.event.LocomotiveListener;
import com.hotels.bdp.circustrain.api.event.ReplicaCatalogListener;
import com.hotels.bdp.circustrain.api.event.SourceCatalogListener;
import com.hotels.bdp.circustrain.api.event.TableReplicationListener;
import com.hotels.bdp.circustrain.api.metrics.Metrics;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LoggingListener
implements TableReplicationListener,
LocomotiveListener,
SourceCatalogListener,
ReplicaCatalogListener,
CopierListener {
    static final Logger LOG = LoggerFactory.getLogger((String)"com.hotels.bdp.circustrain.core.event.LoggingListener:REPLICATION_EVENTS");
    private EventSourceCatalog sourceCatalog;
    private EventReplicaCatalog replicaCatalog;
    private ReplicationState replicationState = new ReplicationState();

    public void tableReplicationStart(EventTableReplication tableReplication, String eventId) {
        this.replicationState = new ReplicationState();
        if (this.sourceCatalog != null && this.replicaCatalog != null) {
            LOG.info("[{}] Attempting to replicate '{}:{}' to '{}:{}'", new Object[]{eventId, this.sourceCatalog.getName(), tableReplication.getSourceTable().getQualifiedName(), this.replicaCatalog.getName(), tableReplication.getQualifiedReplicaName()});
        }
    }

    public void tableReplicationSuccess(EventTableReplication tableReplication, String eventId) {
        String amount = LoggingListener.transferAmount(this.replicationState.partitionKeys, this.replicationState.partitionsAltered);
        if (this.sourceCatalog != null && this.replicaCatalog != null) {
            LOG.info("[{}] Successfully replicated {} of '{}:{}' to '{}:{}' ({} bytes)", new Object[]{eventId, amount, this.sourceCatalog.getName(), tableReplication.getSourceTable().getQualifiedName(), this.replicaCatalog.getName(), tableReplication.getQualifiedReplicaName(), this.replicationState.bytesReplicated});
        }
    }

    public void tableReplicationFailure(EventTableReplication tableReplication, String eventId, Throwable t) {
        if (this.sourceCatalog != null && this.replicaCatalog != null) {
            LOG.error("[{}] Failed to replicate '{}:{}' to '{}:{}' with error '{}'", new Object[]{eventId, this.sourceCatalog.getName(), tableReplication.getSourceTable().getQualifiedName(), this.replicaCatalog.getName(), tableReplication.getQualifiedReplicaName(), t.getMessage()});
        }
    }

    private static String transferAmount(List<String> partitionKeys, int partitionsAltered) {
        return partitionKeys == null || partitionKeys.isEmpty() ? "all" : Integer.toString(partitionsAltered) + " partitions";
    }

    public void circusTrainStartUp(String[] args, EventSourceCatalog sourceCatalog, EventReplicaCatalog replicaCatalog) {
        this.sourceCatalog = sourceCatalog;
        this.replicaCatalog = replicaCatalog;
    }

    public void resolvedMetaStoreSourceTable(EventTable table) {
        this.replicationState.partitionKeys = table.getPartitionKeys();
    }

    public void partitionsToCreate(EventPartitions partitions) {
        this.replicationState.partitionsAltered += partitions.getEventPartitions().size();
    }

    public void partitionsToAlter(EventPartitions partitions) {
        this.replicationState.partitionsAltered += partitions.getEventPartitions().size();
    }

    public void copierEnd(Metrics metrics) {
        this.replicationState.bytesReplicated = metrics.getBytesReplicated();
    }

    public void circusTrainShutDown(CompletionCode completionCode, Map<String, Long> metrics) {
    }

    public void resolvedSourcePartitions(EventPartitions partitions) {
    }

    public void resolvedSourceLocation(URI location) {
    }

    public void resolvedReplicaLocation(URI location) {
    }

    public void existingReplicaPartitions(EventPartitions partitions) {
    }

    public void deprecatedReplicaLocations(List<URI> locations) {
    }

    public void copierStart(String copierImplementation) {
    }

    List<String> getPartitionKeys() {
        return Collections.unmodifiableList(this.replicationState.partitionKeys);
    }

    int getPartitionsAltered() {
        return this.replicationState.partitionsAltered;
    }

    long getBytesReplicated() {
        return this.replicationState.bytesReplicated;
    }

    private static class ReplicationState {
        List<String> partitionKeys = Collections.emptyList();
        int partitionsAltered;
        long bytesReplicated;

        private ReplicationState() {
        }
    }
}

