/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.event;

import com.codahale.metrics.ScheduledReporter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.hotels.bdp.circustrain.api.CompletionCode;
import com.hotels.bdp.circustrain.api.event.CopierListener;
import com.hotels.bdp.circustrain.api.event.EventTableReplication;
import com.hotels.bdp.circustrain.api.event.TableReplicationListener;
import com.hotels.bdp.circustrain.api.metrics.MetricSender;
import com.hotels.bdp.circustrain.api.metrics.Metrics;
import com.hotels.bdp.circustrain.api.metrics.ScheduledReporterFactory;
import com.hotels.bdp.circustrain.api.util.DotJoiner;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
class MetricsListener
implements TableReplicationListener,
CopierListener {
    private final Map<String, Long> startTimes = new HashMap<String, Long>();
    private final MetricSender metricSender;
    private String qualifiedReplicaName;
    private Metrics metrics;
    private ScheduledReporter runningMetricsReporter;
    private final ScheduledReporterFactory runningMetricsReporterFactory;
    private final long metricsReporterPeriod;
    private final TimeUnit metricsReporterTimeUnit;

    @Autowired
    MetricsListener(MetricSender metricSender, ScheduledReporterFactory runningMetricsReporterFactory, @Value(value="${metrics-reporter.period:1}") long metricsReporterPeriod, @Value(value="${metrics-reporter.time-unit:MINUTES}") TimeUnit metricsReporterTimeUnit) {
        this.metricSender = metricSender;
        this.runningMetricsReporterFactory = runningMetricsReporterFactory;
        this.metricsReporterPeriod = metricsReporterPeriod;
        this.metricsReporterTimeUnit = metricsReporterTimeUnit;
    }

    public void tableReplicationStart(EventTableReplication tableReplication, String eventId) {
        this.qualifiedReplicaName = tableReplication.getQualifiedReplicaName();
        this.startTimes.put(this.qualifiedReplicaName, System.currentTimeMillis());
    }

    public void tableReplicationSuccess(EventTableReplication tableReplication, String eventId) {
        this.sendMetrics(CompletionCode.SUCCESS, tableReplication.getQualifiedReplicaName(), this.metrics);
    }

    public void tableReplicationFailure(EventTableReplication tableReplication, String eventId, Throwable t) {
        this.sendMetrics(CompletionCode.FAILURE, tableReplication.getQualifiedReplicaName(), Metrics.NULL_VALUE);
    }

    public void copierEnd(Metrics metrics) {
        if (this.runningMetricsReporter == null) {
            throw new IllegalStateException("Metrics reporter should not be null");
        }
        this.runningMetricsReporter.report();
        this.runningMetricsReporter.stop();
        this.runningMetricsReporter = null;
        this.metrics = metrics;
    }

    private void sendMetrics(CompletionCode completionCode, String target, Metrics metrics) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(this.replicationTime(target));
        builder.put(this.completionCode(target, completionCode));
        if (metrics != null) {
            builder.put(this.bytesReplicated(target, metrics));
            for (Map.Entry metric : metrics.getMetrics().entrySet()) {
                builder.put((Object)DotJoiner.join((String[])new String[]{target, (String)metric.getKey()}), metric.getValue());
            }
        }
        this.metricSender.send((Map)builder.build());
    }

    private Map.Entry<String, Long> replicationTime(String target) {
        Long startTime = this.startTimes.remove(target);
        long replicationTime = -1L;
        if (startTime != null) {
            replicationTime = System.currentTimeMillis() - startTime;
        }
        return Maps.immutableEntry((Object)DotJoiner.join((String[])new String[]{target, "replication_time"}), (Object)replicationTime);
    }

    private Map.Entry<String, Long> completionCode(String target, CompletionCode completionCode) {
        return Maps.immutableEntry((Object)DotJoiner.join((String[])new String[]{target, completionCode.getMetricName()}), (Object)completionCode.getCode());
    }

    private Map.Entry<String, Long> bytesReplicated(String target, Metrics metrics) {
        return Maps.immutableEntry((Object)DotJoiner.join((String[])new String[]{target, "bytes_replicated"}), (Object)metrics.getBytesReplicated());
    }

    public void copierStart(String copierImplementation) {
        this.runningMetricsReporter = this.runningMetricsReporterFactory.newInstance(this.qualifiedReplicaName);
        this.runningMetricsReporter.start(this.metricsReporterPeriod, this.metricsReporterTimeUnit);
        this.runningMetricsReporter.report();
    }
}

