/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.replica;

import com.google.common.base.Function;
import com.hotels.bdp.circustrain.api.CircusTrainTableParameter;
import com.hotels.bdp.circustrain.api.conf.ReplicationMode;
import com.hotels.bdp.circustrain.api.metadata.ColumnStatisticsTransformation;
import com.hotels.bdp.circustrain.api.metadata.PartitionTransformation;
import com.hotels.bdp.circustrain.api.metadata.TableTransformation;
import com.hotels.bdp.circustrain.core.replica.ReplicaTableFactory;
import com.hotels.hcommon.hive.metastore.util.LocationUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

public class AddCheckSumReplicaTableFactory
extends ReplicaTableFactory {
    private final Function<Path, String> checksumFunction;

    AddCheckSumReplicaTableFactory(HiveConf sourceHiveConf, Function<Path, String> checksumFunction, TableTransformation tableTransformation, PartitionTransformation partitionTransformation, ColumnStatisticsTransformation columnStatisticsTransformation) {
        super(sourceHiveConf, tableTransformation, partitionTransformation, columnStatisticsTransformation);
        this.checksumFunction = checksumFunction;
    }

    @Override
    Partition newReplicaPartition(String eventId, Table sourceTable, Partition sourcePartition, String replicaDatabaseName, String replicaTableName, Path replicaPartitionLocation, ReplicationMode replicationMode) {
        Partition replica = super.newReplicaPartition(eventId, sourceTable, sourcePartition, replicaDatabaseName, replicaTableName, replicaPartitionLocation, replicationMode);
        String checksum = (String)this.checksumFunction.apply((Object)LocationUtils.locationAsPath((Partition)sourcePartition));
        replica.putToParameters(CircusTrainTableParameter.PARTITION_CHECKSUM.parameterName(), checksum);
        return replica;
    }
}

