/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.replica;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.hotels.bdp.circustrain.api.CircusTrainTableParameter;
import com.hotels.bdp.circustrain.api.conf.TableReplication;
import com.hotels.bdp.circustrain.core.replica.CleanupLocationManager;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import com.hotels.hcommon.hive.metastore.iterator.PartitionIterator;
import com.hotels.hcommon.hive.metastore.util.LocationUtils;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestructiveReplica {
    private static final Logger log = LoggerFactory.getLogger(DestructiveReplica.class);
    private static final boolean DELETE_DATA = false;
    private static final boolean IGNORE_UNKNOWN = true;
    private final Supplier<CloseableMetaStoreClient> replicaMetaStoreClientSupplier;
    private final TableReplication tableReplication;
    private final String databaseName;
    private final String tableName;
    private final CleanupLocationManager cleanupLocationManager;

    public DestructiveReplica(Supplier<CloseableMetaStoreClient> replicaMetaStoreClientSupplier, CleanupLocationManager cleanupLocationManager, TableReplication tableReplication) {
        this.replicaMetaStoreClientSupplier = replicaMetaStoreClientSupplier;
        this.cleanupLocationManager = cleanupLocationManager;
        this.tableReplication = tableReplication;
        this.databaseName = tableReplication.getReplicaDatabaseName();
        this.tableName = tableReplication.getReplicaTableName();
    }

    public boolean tableIsUnderCircusTrainControl() throws TException {
        try (CloseableMetaStoreClient client = (CloseableMetaStoreClient)this.replicaMetaStoreClientSupplier.get();){
            if (!client.tableExists(this.databaseName, this.tableName)) {
                boolean bl = true;
                return bl;
            }
            String sourceTableParameterValue = (String)client.getTable(this.databaseName, this.tableName).getParameters().get(CircusTrainTableParameter.SOURCE_TABLE.parameterName());
            if (sourceTableParameterValue != null) {
                String qualifiedName = this.tableReplication.getSourceTable().getQualifiedName();
                boolean bl = qualifiedName.equals(sourceTableParameterValue);
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropDeletedPartitions(final List<String> sourcePartitionNames) throws TException {
        try (CloseableMetaStoreClient client = (CloseableMetaStoreClient)this.replicaMetaStoreClientSupplier.get();){
            if (!client.tableExists(this.databaseName, this.tableName)) {
                return;
            }
            this.dropAndDeletePartitions(client, new Predicate<String>(){

                public boolean apply(String partitionName) {
                    return !sourcePartitionNames.contains(partitionName);
                }
            });
        }
        finally {
            this.cleanupLocationManager.scheduleLocations();
        }
    }

    private void dropAndDeletePartitions(CloseableMetaStoreClient client, Predicate<String> shouldDelete) throws MetaException, TException, NoSuchObjectException {
        Table replicaTable = client.getTable(this.databaseName, this.tableName);
        List partitionKeys = replicaTable.getPartitionKeys();
        if (partitionKeys == null || partitionKeys.isEmpty()) {
            return;
        }
        PartitionIterator partitionIterator = new PartitionIterator((IMetaStoreClient)client, replicaTable, 1000);
        while (partitionIterator.hasNext()) {
            Partition replicaPartition = partitionIterator.next();
            List values = replicaPartition.getValues();
            String partitionName = Warehouse.makePartName((List)partitionKeys, (List)values);
            if (!shouldDelete.apply((Object)partitionName)) continue;
            log.info("Dropping partition for replica table: " + this.databaseName + "." + this.tableName + ", partition value: '" + partitionName + "'");
            client.dropPartition(this.databaseName, this.tableName, partitionName, false);
            Path oldLocation = LocationUtils.locationAsPath((Partition)replicaPartition);
            String oldEventId = (String)replicaPartition.getParameters().get(CircusTrainTableParameter.REPLICATION_EVENT.parameterName());
            this.cleanupLocationManager.addCleanupLocation(oldEventId, oldLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable() throws TException {
        try (CloseableMetaStoreClient client = (CloseableMetaStoreClient)this.replicaMetaStoreClientSupplier.get();){
            if (!client.tableExists(this.databaseName, this.tableName)) {
                return;
            }
            this.dropAndDeletePartitions(client, (Predicate<String>)Predicates.alwaysTrue());
            Table table = client.getTable(this.databaseName, this.tableName);
            log.info("Dropping replica table: " + this.databaseName + "." + this.tableName);
            client.dropTable(this.databaseName, this.tableName, false, true);
            Path oldLocation = LocationUtils.locationAsPath((Table)table);
            String oldEventId = (String)table.getParameters().get(CircusTrainTableParameter.REPLICATION_EVENT.parameterName());
            this.cleanupLocationManager.addCleanupLocation(oldEventId, oldLocation);
        }
        finally {
            this.cleanupLocationManager.scheduleLocations();
        }
    }
}

