/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.replica;

import com.hotels.bdp.circustrain.api.ReplicaLocationManager;
import com.hotels.bdp.circustrain.api.SourceLocationManager;
import com.hotels.bdp.circustrain.api.event.ReplicaCatalogListener;
import com.hotels.bdp.circustrain.core.replica.CleanupLocationManager;
import com.hotels.bdp.circustrain.core.replica.TableType;
import com.hotels.hcommon.hive.metastore.util.LocationUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullReplicationReplicaLocationManager
implements ReplicaLocationManager {
    private static final Logger LOG = LoggerFactory.getLogger(FullReplicationReplicaLocationManager.class);
    private final SourceLocationManager sourceLocationManager;
    private final String tablePath;
    private final String eventId;
    private final TableType tableType;
    private final CleanupLocationManager cleanupLocationManager;
    private final ReplicaCatalogListener replicaCatalogListener;

    FullReplicationReplicaLocationManager(SourceLocationManager sourceLocationManager, String tablePath, String eventId, TableType tableType, CleanupLocationManager cleanupLocationManager, ReplicaCatalogListener replicaCatalogListener) {
        this.sourceLocationManager = sourceLocationManager;
        this.tablePath = tablePath;
        this.eventId = eventId;
        this.tableType = tableType;
        this.cleanupLocationManager = cleanupLocationManager;
        this.replicaCatalogListener = replicaCatalogListener;
    }

    public Path getTableLocation() {
        Path replicaDataLocation = new Path(this.tablePath);
        if (this.tableType == TableType.UNPARTITIONED) {
            replicaDataLocation = new Path(replicaDataLocation, this.eventId);
        }
        LOG.debug("Generated table data destination path: {}", (Object)replicaDataLocation.toUri());
        this.replicaCatalogListener.resolvedReplicaLocation(replicaDataLocation.toUri());
        return replicaDataLocation;
    }

    public Path getPartitionBaseLocation() {
        if (this.tableType == TableType.UNPARTITIONED) {
            throw new UnsupportedOperationException("Not a partitioned table.");
        }
        Path partitionBasePath = new Path(this.getTableLocation(), this.eventId);
        LOG.debug("Generated partition data destination base path: {}", (Object)partitionBasePath.toUri());
        return partitionBasePath;
    }

    public void addCleanUpLocation(String pathEventId, Path location) {
        this.cleanupLocationManager.addCleanupLocation(pathEventId, location);
    }

    public void cleanUpLocations() {
        this.cleanupLocationManager.scheduleLocations();
    }

    public Path getPartitionLocation(Partition sourcePartition) {
        if (this.tableType == TableType.UNPARTITIONED) {
            throw new UnsupportedOperationException("Not a partitioned table.");
        }
        Path partitionSubPath = this.sourceLocationManager.getPartitionSubPath(LocationUtils.locationAsPath((Partition)sourcePartition));
        Path replicaPartitionLocation = new Path(this.getPartitionBaseLocation(), partitionSubPath);
        return replicaPartitionLocation;
    }
}

