/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.replica;

import com.hotels.bdp.circustrain.api.CircusTrainException;
import com.hotels.bdp.circustrain.api.event.ReplicaCatalogListener;
import com.hotels.bdp.circustrain.api.listener.HousekeepingListener;
import com.hotels.bdp.circustrain.core.replica.CleanupLocationManager;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HousekeepingCleanupLocationManager
implements CleanupLocationManager {
    private static final Logger LOG = LoggerFactory.getLogger(HousekeepingCleanupLocationManager.class);
    private final String eventId;
    private final HousekeepingListener housekeepingListener;
    private final ReplicaCatalogListener replicaCatalogListener;
    private final List<CleanupLocation> locations = new ArrayList<CleanupLocation>();
    private final String replicaDatabase;
    private final String replicaTable;

    public HousekeepingCleanupLocationManager(String eventId, HousekeepingListener housekeepingListener, ReplicaCatalogListener replicaCatalogListener, String replicaDatabase, String replicaTable) {
        this.eventId = eventId;
        this.housekeepingListener = housekeepingListener;
        this.replicaCatalogListener = replicaCatalogListener;
        this.replicaDatabase = replicaDatabase;
        this.replicaTable = replicaTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleLocations() throws CircusTrainException {
        try {
            ArrayList<URI> uris = new ArrayList<URI>();
            for (CleanupLocation location : this.locations) {
                LOG.info("Scheduling old replica data for deletion for event {}: {}", (Object)this.eventId, (Object)location.path.toUri());
                this.housekeepingListener.cleanUpLocation(this.eventId, location.pathEventId, location.path, location.replicaDatabase, location.replicaTable);
                uris.add(location.path.toUri());
            }
            this.replicaCatalogListener.deprecatedReplicaLocations(uris);
        }
        finally {
            this.locations.clear();
        }
    }

    @Override
    public void addCleanupLocation(String pathEventId, Path location) {
        LOG.debug("Adding clean up location: {}", (Object)location.toUri());
        this.locations.add(new CleanupLocation(pathEventId, location, this.replicaDatabase, this.replicaTable));
    }

    private static class CleanupLocation {
        private final Path path;
        private final String pathEventId;
        private final String replicaDatabase;
        private final String replicaTable;

        private CleanupLocation(String pathEventId, Path path, String replicaDatabase, String replicaTable) {
            this.pathEventId = pathEventId;
            this.path = path;
            this.replicaDatabase = replicaDatabase;
            this.replicaTable = replicaTable;
        }
    }
}

