/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.replica;

import com.hotels.bdp.circustrain.api.CircusTrainException;
import com.hotels.bdp.circustrain.api.ReplicaLocationManager;
import com.hotels.bdp.circustrain.api.SourceLocationManager;
import com.hotels.bdp.circustrain.core.replica.TableType;
import com.hotels.hcommon.hive.metastore.util.LocationUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Partition;

public class MetadataMirrorReplicaLocationManager
implements ReplicaLocationManager {
    private final SourceLocationManager sourceLocationManager;
    private final TableType tableType;

    public MetadataMirrorReplicaLocationManager(SourceLocationManager sourceLocationManager, TableType tableType) {
        this.sourceLocationManager = sourceLocationManager;
        this.tableType = tableType;
    }

    public Path getTableLocation() throws CircusTrainException {
        return this.sourceLocationManager.getTableLocation();
    }

    public Path getPartitionBaseLocation() throws CircusTrainException {
        if (this.tableType == TableType.UNPARTITIONED) {
            throw new UnsupportedOperationException("Not a partitioned table.");
        }
        return this.getTableLocation();
    }

    public void cleanUpLocations() throws CircusTrainException {
    }

    public void addCleanUpLocation(String pathEventId, Path location) {
    }

    public Path getPartitionLocation(Partition sourcePartition) {
        if (this.tableType == TableType.UNPARTITIONED) {
            throw new UnsupportedOperationException("Not a partitioned table.");
        }
        if (!LocationUtils.hasLocation((Partition)sourcePartition)) {
            return null;
        }
        return new Path(sourcePartition.getSd().getLocation());
    }
}

