/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.replica;

import com.hotels.bdp.circustrain.api.CircusTrainException;
import com.hotels.bdp.circustrain.api.ReplicaLocationManager;
import com.hotels.bdp.circustrain.core.replica.TableType;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.thrift.TException;

public class MetadataUpdateReplicaLocationManager
implements ReplicaLocationManager {
    private final CloseableMetaStoreClient replicaMetastoreClient;
    private final TableType tableType;
    private final String tablePath;
    private final String replicaDatabaseName;
    private final String replicaTableName;

    public MetadataUpdateReplicaLocationManager(CloseableMetaStoreClient replicaMetastoreClient, TableType tableType, String tablePath, String replicaDatabaseName, String replicaTableName) {
        this.replicaMetastoreClient = replicaMetastoreClient;
        this.tableType = tableType;
        this.tablePath = tablePath;
        this.replicaDatabaseName = replicaDatabaseName;
        this.replicaTableName = replicaTableName;
    }

    public Path getTableLocation() {
        return new Path(this.tablePath);
    }

    public Path getPartitionBaseLocation() {
        if (this.tableType == TableType.UNPARTITIONED) {
            throw new UnsupportedOperationException("Not a partitioned table.");
        }
        return this.getTableLocation();
    }

    public void cleanUpLocations() throws CircusTrainException {
    }

    public void addCleanUpLocation(String pathEventId, Path location) {
    }

    public Path getPartitionLocation(Partition sourcePartition) {
        if (this.tableType == TableType.UNPARTITIONED) {
            throw new UnsupportedOperationException("Not a partitioned table.");
        }
        try {
            Partition partition = this.replicaMetastoreClient.getPartition(this.replicaDatabaseName, this.replicaTableName, sourcePartition.getValues());
            return new Path(partition.getSd().getLocation());
        }
        catch (TException e) {
            throw new CircusTrainException("Partition should exist on replica but doesn't", (Throwable)e);
        }
    }
}

