/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.replica;

import com.google.common.base.Supplier;
import com.hotels.bdp.circustrain.api.conf.ReplicaCatalog;
import com.hotels.bdp.circustrain.api.conf.TableReplication;
import com.hotels.bdp.circustrain.api.event.ReplicaCatalogListener;
import com.hotels.bdp.circustrain.api.listener.HousekeepingListener;
import com.hotels.bdp.circustrain.core.HiveEndpointFactory;
import com.hotels.bdp.circustrain.core.replica.Replica;
import com.hotels.bdp.circustrain.core.replica.ReplicaTableFactory;
import com.hotels.bdp.circustrain.core.replica.ReplicaTableFactoryProvider;
import com.hotels.bdp.circustrain.core.replica.hive.AlterTableService;
import com.hotels.bdp.circustrain.core.replica.hive.CopyPartitionsOperation;
import com.hotels.bdp.circustrain.core.replica.hive.DropTableService;
import com.hotels.bdp.circustrain.core.replica.hive.RenameTableOperation;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import org.apache.hadoop.hive.conf.HiveConf;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"replication"})
@Component
public class ReplicaFactory
implements HiveEndpointFactory<Replica> {
    private final ReplicaCatalog replicaCatalog;
    private final HiveConf replicaHiveConf;
    private final Supplier<CloseableMetaStoreClient> replicaMetaStoreClientSupplier;
    private final HousekeepingListener housekeepingListener;
    private final ReplicaCatalogListener replicaCatalogListener;
    private final ReplicaTableFactoryProvider replicaTableFactoryPicker;

    @Autowired
    public ReplicaFactory(ReplicaCatalog replicaCatalog, @Value(value="#{replicaHiveConf}") HiveConf replicaHiveConf, Supplier<CloseableMetaStoreClient> replicaMetaStoreClientSupplier, HousekeepingListener housekeepingListener, ReplicaCatalogListener replicaCatalogListener, ReplicaTableFactoryProvider replicaTableFactoryProvider) {
        this.replicaCatalog = replicaCatalog;
        this.replicaHiveConf = replicaHiveConf;
        this.replicaMetaStoreClientSupplier = replicaMetaStoreClientSupplier;
        this.housekeepingListener = housekeepingListener;
        this.replicaCatalogListener = replicaCatalogListener;
        this.replicaTableFactoryPicker = replicaTableFactoryProvider;
    }

    @Override
    public Replica newInstance(TableReplication tableReplication) {
        ReplicaTableFactory replicaTableFactory = this.replicaTableFactoryPicker.newInstance(tableReplication);
        DropTableService dropTableService = new DropTableService();
        AlterTableService alterTableService = new AlterTableService(dropTableService, new CopyPartitionsOperation(), new RenameTableOperation(dropTableService));
        return new Replica(this.replicaCatalog, this.replicaHiveConf, this.replicaMetaStoreClientSupplier, replicaTableFactory, this.housekeepingListener, this.replicaCatalogListener, tableReplication, alterTableService);
    }
}

