/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.replica;

import com.hotels.bdp.circustrain.api.CircusTrainTableParameter;
import com.hotels.bdp.circustrain.api.conf.ReplicationMode;
import com.hotels.bdp.circustrain.api.metadata.ColumnStatisticsTransformation;
import com.hotels.bdp.circustrain.api.metadata.PartitionTransformation;
import com.hotels.bdp.circustrain.api.metadata.TableTransformation;
import com.hotels.bdp.circustrain.core.TableAndStatistics;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ReplicaTableFactory {
    private static final String DO_NOT_UPDATE_STATS = "DO_NOT_UPDATE_STATS";
    private static final String STATS_GENERATED_VIA_STATS_TASK = "STATS_GENERATED_VIA_STATS_TASK";
    private static final String STATS_GENERATED = "STATS_GENERATED";
    private static final String EXTERNAL = "EXTERNAL";
    private final String sourceMetaStoreUris;
    private final TableTransformation tableTransformation;
    private final PartitionTransformation partitionTransformation;
    private final ColumnStatisticsTransformation columnStatisticsTransformation;

    ReplicaTableFactory(HiveConf sourceHiveConf, TableTransformation tableTransformation, PartitionTransformation partitionTransformation, ColumnStatisticsTransformation columnStatisticsTransformation) {
        this(sourceHiveConf.getVar(HiveConf.ConfVars.METASTOREURIS), tableTransformation, partitionTransformation, columnStatisticsTransformation);
    }

    ReplicaTableFactory(String sourceMetaStoreUris, TableTransformation tableTransformation, PartitionTransformation partitionTransformation, ColumnStatisticsTransformation columnStatisticsTransformation) {
        this.sourceMetaStoreUris = sourceMetaStoreUris;
        this.tableTransformation = tableTransformation;
        this.partitionTransformation = partitionTransformation;
        this.columnStatisticsTransformation = columnStatisticsTransformation;
    }

    TableAndStatistics newReplicaTable(String eventId, TableAndStatistics sourceTableAndStatistics, String replicaDatabaseName, String replicaTableName, Path replicaDataDestination, ReplicationMode replicationMode) {
        Table sourceTable = sourceTableAndStatistics.getTable();
        Table replica = this.tableTransformation.transform(new Table(sourceTable));
        replica.setDbName(replicaDatabaseName);
        replica.setTableName(replicaTableName);
        replica.getSd().setLocation(this.toStringOrNull(replicaDataDestination));
        this.setReplicaTableType(sourceTable, replica);
        replica.putToParameters(STATS_GENERATED_VIA_STATS_TASK, Boolean.TRUE.toString());
        replica.putToParameters(STATS_GENERATED, Boolean.TRUE.toString());
        replica.putToParameters(DO_NOT_UPDATE_STATS, Boolean.TRUE.toString());
        replica.putToParameters(CircusTrainTableParameter.LAST_REPLICATED.parameterName(), DateTime.now((DateTimeZone)DateTimeZone.UTC).toString());
        replica.putToParameters(CircusTrainTableParameter.REPLICATION_EVENT.parameterName(), eventId);
        replica.putToParameters(CircusTrainTableParameter.SOURCE_LOCATION.parameterName(), this.toStringOrEmpty(sourceTable.getSd().getLocation()));
        replica.putToParameters(CircusTrainTableParameter.SOURCE_TABLE.parameterName(), Warehouse.getQualifiedName((Table)sourceTable));
        replica.putToParameters(CircusTrainTableParameter.SOURCE_METASTORE.parameterName(), this.sourceMetaStoreUris);
        replica.putToParameters(CircusTrainTableParameter.REPLICATION_MODE.parameterName(), replicationMode.name());
        ColumnStatistics replicaColumnStats = null;
        if (sourceTableAndStatistics.getStatistics() != null) {
            replicaColumnStats = new ColumnStatistics(new ColumnStatisticsDesc(true, replica.getDbName(), replica.getTableName()), sourceTableAndStatistics.getStatistics().getStatsObj());
            replicaColumnStats = this.columnStatisticsTransformation.transform(replicaColumnStats);
        }
        return new TableAndStatistics(replica, replicaColumnStats);
    }

    private String toStringOrEmpty(Object value) {
        return Objects.toString(value, "");
    }

    private String toStringOrNull(Object value) {
        return value != null ? value.toString() : null;
    }

    private void setReplicaTableType(Table source, Table replica) {
        if (TableType.VIRTUAL_VIEW.name().equals(source.getTableType())) {
            replica.setTableType(TableType.VIRTUAL_VIEW.name());
            return;
        }
        replica.setTableType(TableType.EXTERNAL_TABLE.name());
        replica.putToParameters(EXTERNAL, "TRUE");
    }

    Partition newReplicaPartition(String eventId, Table sourceTable, Partition sourcePartition, String replicaDatabaseName, String replicaTableName, Path replicaPartitionLocation, ReplicationMode replicationMode) {
        Partition replica = this.partitionTransformation.transform(new Partition(sourcePartition));
        replica.setDbName(replicaDatabaseName);
        replica.setTableName(replicaTableName);
        if (replica.getSd() != null) {
            replica.getSd().setLocation(this.toStringOrNull(replicaPartitionLocation));
        }
        String sourcePartitionLocation = sourcePartition.getSd() == null ? "" : this.toStringOrEmpty(sourcePartition.getSd().getLocation());
        replica.putToParameters(STATS_GENERATED_VIA_STATS_TASK, Boolean.TRUE.toString());
        replica.putToParameters(STATS_GENERATED, Boolean.TRUE.toString());
        replica.putToParameters(DO_NOT_UPDATE_STATS, Boolean.TRUE.toString());
        replica.putToParameters(CircusTrainTableParameter.LAST_REPLICATED.parameterName(), DateTime.now((DateTimeZone)DateTimeZone.UTC).toString());
        replica.putToParameters(CircusTrainTableParameter.REPLICATION_EVENT.parameterName(), eventId);
        replica.putToParameters(CircusTrainTableParameter.SOURCE_LOCATION.parameterName(), sourcePartitionLocation);
        replica.putToParameters(CircusTrainTableParameter.SOURCE_TABLE.parameterName(), Warehouse.getQualifiedName((Table)sourceTable));
        replica.putToParameters(CircusTrainTableParameter.SOURCE_METASTORE.parameterName(), this.sourceMetaStoreUris);
        replica.putToParameters(CircusTrainTableParameter.REPLICATION_MODE.parameterName(), replicationMode.name());
        return replica;
    }

    ColumnStatistics newReplicaPartitionStatistics(Table replicaTable, Partition replicaPartition, ColumnStatistics sourcePartitionStatistics) {
        ColumnStatisticsDesc statisticsDesc = new ColumnStatisticsDesc(false, replicaPartition.getDbName(), replicaPartition.getTableName());
        try {
            statisticsDesc.setPartName(Warehouse.makePartName((List)replicaTable.getPartitionKeys(), (List)replicaPartition.getValues()));
        }
        catch (MetaException e) {
            throw new RuntimeException(e);
        }
        return this.columnStatisticsTransformation.transform(new ColumnStatistics(statisticsDesc, sourcePartitionStatistics.getStatsObj()));
    }
}

