/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.replica;

import com.google.common.base.Function;
import com.hotels.bdp.circustrain.api.conf.TableReplication;
import com.hotels.bdp.circustrain.api.metadata.ColumnStatisticsTransformation;
import com.hotels.bdp.circustrain.api.metadata.PartitionTransformation;
import com.hotels.bdp.circustrain.api.metadata.TableTransformation;
import com.hotels.bdp.circustrain.core.replica.AddCheckSumReplicaTableFactory;
import com.hotels.bdp.circustrain.core.replica.ReplicaTableFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"replication"})
@Component
public class ReplicaTableFactoryProvider {
    private final HiveConf sourceHiveConf;
    private final Function<Path, String> checksumFunction;
    private final TableTransformation tableTransformation;
    private final PartitionTransformation partitionTransformation;
    private final ColumnStatisticsTransformation columnStatisticsTransformation;

    @Autowired
    public ReplicaTableFactoryProvider(@Value(value="#{sourceHiveConf}") HiveConf sourceHiveConf, @Value(value="#{checksumFunction}") Function<Path, String> checksumFunction, TableTransformation tableTransformation, PartitionTransformation partitionTransformation, ColumnStatisticsTransformation columnStatisticsTransformation) {
        this.sourceHiveConf = sourceHiveConf;
        this.checksumFunction = checksumFunction;
        this.tableTransformation = tableTransformation;
        this.partitionTransformation = partitionTransformation;
        this.columnStatisticsTransformation = columnStatisticsTransformation;
    }

    public ReplicaTableFactory newInstance(TableReplication tableReplication) {
        if (tableReplication.getSourceTable().isGeneratePartitionFilter()) {
            return new AddCheckSumReplicaTableFactory(this.sourceHiveConf, this.checksumFunction, this.tableTransformation, this.partitionTransformation, this.columnStatisticsTransformation);
        }
        return new ReplicaTableFactory(this.sourceHiveConf, this.tableTransformation, this.partitionTransformation, this.columnStatisticsTransformation);
    }
}

