/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.replica.hive;

import com.hotels.bdp.circustrain.core.replica.hive.CopyPartitionsOperation;
import com.hotels.bdp.circustrain.core.replica.hive.DropTableService;
import com.hotels.bdp.circustrain.core.replica.hive.RenameTableOperation;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterTableService {
    private static final Logger LOG = LoggerFactory.getLogger(AlterTableService.class);
    private DropTableService dropTableService;
    private CopyPartitionsOperation copyPartitionsOperation;
    private RenameTableOperation renameTableOperation;

    public AlterTableService(DropTableService dropTableService, CopyPartitionsOperation copyPartitionsOperation, RenameTableOperation renameTableOperation) {
        this.dropTableService = dropTableService;
        this.copyPartitionsOperation = copyPartitionsOperation;
        this.renameTableOperation = renameTableOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterTable(CloseableMetaStoreClient client, Table oldTable, Table newTable) throws Exception {
        List newColumns;
        List oldColumns = oldTable.getSd().getCols();
        if (this.hasAnyChangedColumns(oldColumns, newColumns = newTable.getSd().getCols())) {
            LOG.info("Found columns that have changed type, attempting to recreate target table with the new columns.Old columns: {}, new columns: {}", (Object)oldColumns, (Object)newColumns);
            Table tempTable = new Table(newTable);
            String tempName = newTable.getTableName() + "_temp";
            tempTable.setTableName(tempName);
            try {
                client.createTable(tempTable);
                this.copyPartitionsOperation.execute(client, newTable, tempTable);
                this.renameTableOperation.execute(client, tempTable, newTable);
            }
            finally {
                this.dropTableService.dropTable(client, tempTable.getDbName(), tempName);
            }
        } else {
            client.alter_table(newTable.getDbName(), newTable.getTableName(), newTable);
        }
    }

    private boolean hasAnyChangedColumns(List<FieldSchema> oldColumns, List<FieldSchema> newColumns) {
        Map oldColumnsMap = oldColumns.stream().collect(Collectors.toMap(FieldSchema::getName, Function.identity()));
        for (FieldSchema newColumn : newColumns) {
            FieldSchema oldColumn;
            if (!oldColumnsMap.containsKey(newColumn.getName()) || (oldColumn = (FieldSchema)oldColumnsMap.get(newColumn.getName())).getType().equals(newColumn.getType())) continue;
            return true;
        }
        return false;
    }
}

