/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.replica.hive;

import com.google.common.annotations.VisibleForTesting;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import com.hotels.hcommon.hive.metastore.iterator.PartitionIterator;
import java.util.ArrayList;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyPartitionsOperation {
    private static final Logger LOG = LoggerFactory.getLogger(CopyPartitionsOperation.class);
    private static final short DEFAULT_BATCH_SIZE = 1000;
    private short partitionBatchSize;

    public CopyPartitionsOperation() {
        this(1000);
    }

    @VisibleForTesting
    CopyPartitionsOperation(short partitionBatchSize) {
        this.partitionBatchSize = partitionBatchSize;
    }

    public void execute(CloseableMetaStoreClient client, Table oldTable, Table newTable) throws TException {
        int count = 0;
        String databaseName = newTable.getDbName();
        String tableName = newTable.getTableName();
        PartitionIterator partitionIterator = new PartitionIterator((IMetaStoreClient)client, oldTable, this.partitionBatchSize);
        while (partitionIterator.hasNext()) {
            ArrayList<Partition> batch = new ArrayList<Partition>();
            for (int i = 0; i < this.partitionBatchSize && partitionIterator.hasNext(); ++i) {
                Partition partition = partitionIterator.next();
                ++count;
                Partition copy = new Partition(partition);
                copy.setDbName(databaseName);
                copy.setTableName(tableName);
                StorageDescriptor sd = new StorageDescriptor(partition.getSd());
                sd.setCols(newTable.getSd().getCols());
                copy.setSd(sd);
                batch.add(copy);
            }
            LOG.info("Copying batch of size {} to {}.{}", new Object[]{batch.size(), databaseName, tableName});
            client.add_partitions(batch);
        }
        LOG.info("Copied {} partitions to {}.{}", new Object[]{count, databaseName, tableName});
    }
}

