/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.replica.hive;

import com.hotels.bdp.circustrain.api.data.DataManipulator;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import com.hotels.hcommon.hive.metastore.iterator.PartitionIterator;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTableService {
    private static final Logger log = LoggerFactory.getLogger(DropTableService.class);
    private static final String EXTERNAL_KEY = "EXTERNAL";
    private static final String IS_EXTERNAL = "TRUE";
    private static final short BATCH_SIZE = 1000;

    public void dropTable(CloseableMetaStoreClient client, String databaseName, String tableName) throws Exception {
        Table table = this.getTable(client, databaseName, tableName);
        if (table != null) {
            this.removeTableParamsAndDrop(client, table, databaseName, tableName);
        }
    }

    public void dropTableAndData(CloseableMetaStoreClient client, String databaseName, String tableName, DataManipulator dataManipulator) throws Exception {
        Table table = this.getTable(client, databaseName, tableName);
        if (table != null) {
            String replicaLocation = table.getSd().getLocation();
            if (table.getPartitionKeysSize() == 0) {
                this.deleteData(dataManipulator, replicaLocation);
            } else {
                this.deletePartitionData(client, table, dataManipulator);
            }
            this.removeTableParamsAndDrop(client, table, databaseName, tableName);
        }
    }

    private void removeTableParamsAndDrop(CloseableMetaStoreClient client, Table table, String databaseName, String tableName) throws TException {
        Map tableParameters = table.getParameters();
        if (tableParameters != null && !tableParameters.isEmpty()) {
            if (this.isExternal(tableParameters)) {
                table.setParameters(Collections.singletonMap(EXTERNAL_KEY, IS_EXTERNAL));
            } else {
                table.setParameters(Collections.emptyMap());
            }
            client.alter_table(databaseName, tableName, table);
        }
        log.info("Dropping replica table '{}.{}'.", (Object)databaseName, (Object)tableName);
        client.dropTable(databaseName, tableName, false, true);
    }

    private void deleteData(DataManipulator dataManipulator, String replicaDataLocation) throws Exception {
        try {
            log.debug("Deleting table data from location: {}.", (Object)replicaDataLocation);
            dataManipulator.delete(replicaDataLocation);
        }
        catch (IOException e) {
            throw new Exception("Error deleting data for existing replica table.", e);
        }
    }

    private void deletePartitionData(CloseableMetaStoreClient client, Table table, DataManipulator dataManipulator) throws Exception {
        PartitionIterator partitionIterator = new PartitionIterator((IMetaStoreClient)client, table, 1000);
        while (partitionIterator.hasNext()) {
            String location = partitionIterator.next().getSd().getLocation();
            this.deleteData(dataManipulator, location);
        }
    }

    private Table getTable(CloseableMetaStoreClient client, String databaseName, String tableName) throws Exception {
        Table table = null;
        try {
            table = client.getTable(databaseName, tableName);
        }
        catch (NoSuchObjectException e) {
            log.info("No replica table '" + databaseName + "." + tableName + "' found. Nothing to delete.");
        }
        return table;
    }

    private boolean isExternal(Map<String, String> tableParameters) {
        CaseInsensitiveMap caseInsensitiveParams = new CaseInsensitiveMap(tableParameters);
        return IS_EXTERNAL.equalsIgnoreCase((String)caseInsensitiveParams.get((Object)EXTERNAL_KEY));
    }
}

