/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.replica.hive;

import com.hotels.bdp.circustrain.core.replica.hive.DropTableService;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameTableOperation {
    private static final Logger LOG = LoggerFactory.getLogger(RenameTableOperation.class);
    private static final String DELETE_ME = "_delete_me";
    private final DropTableService dropTableService;

    public RenameTableOperation(DropTableService dropTableService) {
        this.dropTableService = dropTableService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CloseableMetaStoreClient client, Table from, Table to) throws Exception {
        LOG.info("Renaming table {}.{} to {}.{}", new Object[]{from.getDbName(), from.getTableName(), to.getDbName(), to.getTableName()});
        Table fromTable = client.getTable(from.getDbName(), from.getTableName());
        Table toTable = client.getTable(to.getDbName(), to.getTableName());
        String fromDatabaseName = fromTable.getDbName();
        String fromTableName = fromTable.getTableName();
        String toDatabaseName = toTable.getDbName();
        String toTableName = toTable.getTableName();
        String toDelete = toTableName + DELETE_ME;
        try {
            toTable.setTableName(toDelete);
            LOG.info("Altering table {}.{} to {}.{}", new Object[]{toDatabaseName, toTableName, toTable.getDbName(), toTable.getTableName()});
            client.alter_table(toDatabaseName, toTableName, toTable);
            fromTable.setDbName(toTable.getDbName());
            fromTable.setTableName(toTableName);
            LOG.info("Altering table {}.{} to {}.{}", new Object[]{fromDatabaseName, fromTableName, fromTable.getDbName(), fromTable.getTableName()});
            client.alter_table(fromDatabaseName, fromTableName, fromTable);
        }
        finally {
            LOG.info("Dropping table {}.{}", (Object)toTable.getDbName(), (Object)toDelete);
            this.dropTableService.dropTable(client, toTable.getDbName(), toDelete);
        }
    }
}

