/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.source;

import com.google.common.base.Supplier;
import com.hotels.bdp.circustrain.api.conf.TableReplication;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import java.util.List;
import org.apache.thrift.TException;

public class DestructiveSource {
    private static final short ALL = -1;
    private final Supplier<CloseableMetaStoreClient> sourceMetaStoreClientSupplier;
    private final String databaseName;
    private final String tableName;

    public DestructiveSource(Supplier<CloseableMetaStoreClient> sourceMetaStoreClientSupplier, TableReplication tableReplication) {
        this.sourceMetaStoreClientSupplier = sourceMetaStoreClientSupplier;
        this.databaseName = tableReplication.getSourceTable().getDatabaseName();
        this.tableName = tableReplication.getSourceTable().getTableName();
    }

    public boolean tableExists() throws TException {
        try (CloseableMetaStoreClient client = (CloseableMetaStoreClient)this.sourceMetaStoreClientSupplier.get();){
            boolean bl = client.tableExists(this.databaseName, this.tableName);
            return bl;
        }
    }

    public List<String> getPartitionNames() throws TException {
        try (CloseableMetaStoreClient client = (CloseableMetaStoreClient)this.sourceMetaStoreClientSupplier.get();){
            List list = client.listPartitionNames(this.databaseName, this.tableName, (short)-1);
            return list;
        }
    }
}

