/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.source;

import com.hotels.bdp.circustrain.api.CircusTrainException;
import com.hotels.bdp.circustrain.api.SourceLocationManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterMissingPartitionsLocationManager
implements SourceLocationManager {
    private static final Logger LOG = LoggerFactory.getLogger(FilterMissingPartitionsLocationManager.class);
    private final SourceLocationManager sourceLocationManager;
    private final HiveConf hiveConf;

    public FilterMissingPartitionsLocationManager(SourceLocationManager sourceLocationManager, HiveConf hiveConf) {
        this.sourceLocationManager = sourceLocationManager;
        this.hiveConf = hiveConf;
    }

    public Path getTableLocation() throws CircusTrainException {
        return this.sourceLocationManager.getTableLocation();
    }

    public List<Path> getPartitionLocations() throws CircusTrainException {
        ArrayList<Path> result = new ArrayList<Path>();
        List paths = this.sourceLocationManager.getPartitionLocations();
        FileSystem fileSystem = null;
        for (Path path : paths) {
            try {
                if (fileSystem == null) {
                    fileSystem = path.getFileSystem((Configuration)this.hiveConf);
                }
                if (fileSystem.exists(path)) {
                    result.add(path);
                    continue;
                }
                LOG.warn("Source path '{}' does not exist skipping it for replication. WARNING: this means there is a partition in Hive that does not have a corresponding folder in source file store, check your table and data.", (Object)path);
            }
            catch (IOException e) {
                LOG.warn("Exception while checking path, skipping path '{}',  error {}", (Object)path, (Object)e);
            }
        }
        return result;
    }

    public void cleanUpLocations() throws CircusTrainException {
        this.sourceLocationManager.cleanUpLocations();
    }

    public Path getPartitionSubPath(Path partitionLocation) {
        return this.sourceLocationManager.getPartitionSubPath(partitionLocation);
    }
}

