/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.source;

import com.hotels.bdp.circustrain.api.CircusTrainException;
import com.hotels.bdp.circustrain.api.SourceLocationManager;
import com.hotels.bdp.circustrain.api.event.SourceCatalogListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsSnapshotLocationManager
implements SourceLocationManager {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsSnapshotLocationManager.class);
    private final HiveConf sourceHiveConf;
    private final String eventId;
    private final Path sourceDataPath;
    private final Table sourceTable;
    private Path snapshotPath;
    private final List<Path> subPaths;
    private final Path copyBasePath;
    private final boolean snapshotsDisabled;
    private final FileSystemFactory fileSystemFactory;
    private final SourceCatalogListener sourceCatalogListener;

    HdfsSnapshotLocationManager(HiveConf sourceHiveConf, String eventId, Table sourceTable, boolean snapshotsDisabled, SourceCatalogListener sourceCatalogListener) throws IOException {
        this(sourceHiveConf, eventId, sourceTable, snapshotsDisabled, null, sourceCatalogListener);
    }

    HdfsSnapshotLocationManager(HiveConf sourceHiveConf, String eventId, Table sourceTable, boolean snapshotsDisabled, String tableBasePath, SourceCatalogListener sourceCatalogListener) throws IOException {
        this(sourceHiveConf, eventId, sourceTable, Collections.emptyList(), snapshotsDisabled, tableBasePath, sourceCatalogListener);
    }

    HdfsSnapshotLocationManager(HiveConf sourceHiveConf, String eventId, Table sourceTable, List<Partition> sourcePartitions, boolean snapshotsDisabled, String tableBasePath, SourceCatalogListener sourceCatalogListener) throws IOException {
        this(sourceHiveConf, eventId, sourceTable, sourcePartitions, snapshotsDisabled, tableBasePath, FileSystemFactory.DEFAULT, sourceCatalogListener);
    }

    HdfsSnapshotLocationManager(HiveConf sourceHiveConf, String eventId, Table sourceTable, List<Partition> sourcePartitions, boolean snapshotsDisabled, String tableBasePath, FileSystemFactory fileSystemFactory, SourceCatalogListener sourceCatalogListener) throws IOException {
        this.sourceHiveConf = sourceHiveConf;
        this.eventId = eventId;
        this.sourceTable = sourceTable;
        this.snapshotsDisabled = snapshotsDisabled;
        this.sourceCatalogListener = sourceCatalogListener;
        this.fileSystemFactory = fileSystemFactory;
        String sourceDataLocation = StringUtils.isNotBlank((String)tableBasePath) ? tableBasePath : sourceTable.getSd().getLocation();
        this.sourceDataPath = new Path(sourceDataLocation);
        this.copyBasePath = this.createSnapshot();
        String copyBaseLocation = this.copyBasePath.toString();
        this.subPaths = HdfsSnapshotLocationManager.calculateSubPaths(sourcePartitions, sourceDataLocation, copyBaseLocation);
    }

    static List<Path> calculateSubPaths(List<Partition> sourcePartitions, String sourceDataLocation, String copyBaseLocation) {
        ArrayList<Path> paths = new ArrayList<Path>(sourcePartitions.size());
        for (Partition partition : sourcePartitions) {
            String partitionLocation = partition.getSd().getLocation();
            String partitionBranch = partitionLocation.replace(sourceDataLocation, "");
            while (partitionBranch.startsWith("/")) {
                partitionBranch = partitionBranch.substring(1);
            }
            Path copyPartitionPath = new Path(copyBaseLocation, partitionBranch);
            paths.add(copyPartitionPath);
            LOG.debug("Added sub-path {}.", (Object)copyPartitionPath.toString());
        }
        return paths;
    }

    public Path getTableLocation() {
        LOG.debug("Copying source data from: {}", (Object)this.copyBasePath.toString());
        this.sourceCatalogListener.resolvedSourceLocation(this.copyBasePath.toUri());
        return this.copyBasePath;
    }

    public void cleanUpLocations() {
        if (this.snapshotPath != null) {
            try {
                LOG.debug("Deleting source data snapshot: {}, {}", (Object)this.sourceDataPath, (Object)this.eventId);
                FileSystem sourceFileSystem = this.fileSystemFactory.get(this.sourceDataPath, (Configuration)this.sourceHiveConf);
                sourceFileSystem.deleteSnapshot(this.sourceDataPath, this.eventId);
            }
            catch (IOException e) {
                LOG.error("Unable to delete source data snapshot: {}, {}", new Object[]{this.sourceDataPath, this.eventId, e});
            }
        }
    }

    public List<Path> getPartitionLocations() {
        return Collections.unmodifiableList(this.subPaths);
    }

    public Path getPartitionSubPath(Path partitionLocation) {
        String sourceDataPathString = this.sourceDataPath.toString();
        String partitionLocationString = partitionLocation.toString();
        if (!partitionLocationString.startsWith(sourceDataPathString)) {
            throw new CircusTrainException("Partition path '" + partitionLocationString + "' does not seem to belong to data source path '" + sourceDataPathString + "'");
        }
        String subPath = partitionLocationString.replace(sourceDataPathString, "");
        if (subPath.charAt(0) == '/') {
            subPath = subPath.substring(1);
        }
        return new Path(subPath);
    }

    private Path createSnapshot() throws IOException {
        LOG.debug("Source table {}.{} has its data located at {}", new Object[]{this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.sourceDataPath});
        FileSystem fileSystem = this.fileSystemFactory.get(this.sourceDataPath, (Configuration)this.sourceHiveConf);
        Path snapshotMetaDataPath = new Path(this.sourceDataPath, ".snapshot");
        Path resolvedLocation = this.sourceDataPath;
        if (fileSystem.exists(snapshotMetaDataPath)) {
            if (this.snapshotsDisabled) {
                LOG.info("Path {} can be snapshot, but feature has been disabled.", (Object)this.sourceDataPath);
            } else {
                LOG.debug("Creating source data snapshot: {}, {}", (Object)this.sourceDataPath, (Object)this.eventId);
                this.snapshotPath = resolvedLocation = fileSystem.makeQualified(fileSystem.createSnapshot(this.sourceDataPath, this.eventId));
            }
        } else {
            LOG.debug("Snapshots not enabled on source location: {}", (Object)this.sourceDataPath);
        }
        return resolvedLocation;
    }

    static interface FileSystemFactory {
        public static final FileSystemFactory DEFAULT = new FileSystemFactory(){

            @Override
            public FileSystem get(Path path, Configuration conf) throws IOException {
                return path.getFileSystem(conf);
            }
        };

        public FileSystem get(Path var1, Configuration var2) throws IOException;
    }
}

