/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.source;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.hotels.bdp.circustrain.api.SourceLocationManager;
import com.hotels.bdp.circustrain.api.conf.SourceCatalog;
import com.hotels.bdp.circustrain.api.conf.SourceTable;
import com.hotels.bdp.circustrain.api.conf.TableReplication;
import com.hotels.bdp.circustrain.api.event.SourceCatalogListener;
import com.hotels.bdp.circustrain.core.HiveEndpoint;
import com.hotels.bdp.circustrain.core.PartitionsAndStatistics;
import com.hotels.bdp.circustrain.core.TableAndStatistics;
import com.hotels.bdp.circustrain.core.event.EventUtils;
import com.hotels.bdp.circustrain.core.source.FilterMissingPartitionsLocationManager;
import com.hotels.bdp.circustrain.core.source.HdfsSnapshotLocationManager;
import com.hotels.bdp.circustrain.core.source.ViewLocationManager;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;

public class Source
extends HiveEndpoint {
    private final String sourceTableLocation;
    private final boolean snapshotsDisabled;
    private final SourceCatalogListener sourceCatalogListener;

    Source(SourceCatalog sourceCatalog, HiveConf sourceHiveConf, Supplier<CloseableMetaStoreClient> sourceMetaStoreClientSupplier, SourceCatalogListener sourceCatalogListener, boolean snapshotsDisabled, String sourceTableLocation) {
        super(sourceCatalog.getName(), sourceHiveConf, sourceMetaStoreClientSupplier);
        this.sourceTableLocation = sourceTableLocation;
        this.sourceCatalogListener = sourceCatalogListener;
        this.snapshotsDisabled = snapshotsDisabled;
    }

    @Override
    public TableAndStatistics getTableAndStatistics(String database, String table) {
        TableAndStatistics sourceTable = super.getTableAndStatistics(database, table);
        this.sourceCatalogListener.resolvedMetaStoreSourceTable(EventUtils.toEventTable(sourceTable.getTable()));
        return sourceTable;
    }

    @Override
    public PartitionsAndStatistics getPartitions(Table sourceTable, String partitionPredicate, int maxPartitions) throws TException {
        PartitionsAndStatistics sourcePartitions = super.getPartitions(sourceTable, partitionPredicate, maxPartitions);
        this.sourceCatalogListener.resolvedSourcePartitions(EventUtils.toEventPartitions(sourceTable, sourcePartitions.getPartitions()));
        return sourcePartitions;
    }

    public SourceLocationManager getLocationManager(Table table, String eventId) throws IOException {
        if (MetaStoreUtils.isView((Table)table)) {
            return new ViewLocationManager();
        }
        return new HdfsSnapshotLocationManager(this.getHiveConf(), eventId, table, this.snapshotsDisabled, this.sourceTableLocation, this.sourceCatalogListener);
    }

    public SourceLocationManager getLocationManager(Table table, List<Partition> partitions, String eventId, Map<String, Object> copierOptions) throws IOException {
        if (MetaStoreUtils.isView((Table)table)) {
            return new ViewLocationManager();
        }
        HdfsSnapshotLocationManager hdfsSnapshotLocationManager = new HdfsSnapshotLocationManager(this.getHiveConf(), eventId, table, partitions, this.snapshotsDisabled, this.sourceTableLocation, this.sourceCatalogListener);
        boolean ignoreMissingFolder = MapUtils.getBooleanValue(copierOptions, (Object)"ignore-missing-partition-folder-errors", (boolean)false);
        if (ignoreMissingFolder) {
            return new FilterMissingPartitionsLocationManager(hdfsSnapshotLocationManager, this.getHiveConf());
        }
        return hdfsSnapshotLocationManager;
    }

    @Override
    public TableAndStatistics getTableAndStatistics(TableReplication tableReplication) {
        SourceTable sourceTable = tableReplication.getSourceTable();
        return super.getTableAndStatistics(sourceTable.getDatabaseName(), sourceTable.getTableName());
    }

    @VisibleForTesting
    boolean isSnapshotsDisabled() {
        return this.snapshotsDisabled;
    }
}

