/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.source;

import com.google.common.base.Supplier;
import com.hotels.bdp.circustrain.api.conf.ReplicationMode;
import com.hotels.bdp.circustrain.api.conf.SourceCatalog;
import com.hotels.bdp.circustrain.api.conf.TableReplication;
import com.hotels.bdp.circustrain.api.event.SourceCatalogListener;
import com.hotels.bdp.circustrain.core.HiveEndpointFactory;
import com.hotels.bdp.circustrain.core.source.Source;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import org.apache.hadoop.hive.conf.HiveConf;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"replication"})
@Component
public class SourceFactory
implements HiveEndpointFactory<Source> {
    private final SourceCatalog sourceCatalog;
    private final HiveConf sourceHiveConf;
    private final Supplier<CloseableMetaStoreClient> sourceMetaStoreClientSupplier;
    private final SourceCatalogListener sourceCatalogListener;

    @Autowired
    public SourceFactory(SourceCatalog sourceCatalog, @Value(value="#{sourceHiveConf}") HiveConf sourceHiveConf, @Value(value="#{sourceMetaStoreClientSupplier}") Supplier<CloseableMetaStoreClient> sourceMetaStoreClientSupplier, SourceCatalogListener sourceCatalogListener) {
        this.sourceCatalog = sourceCatalog;
        this.sourceHiveConf = sourceHiveConf;
        this.sourceMetaStoreClientSupplier = sourceMetaStoreClientSupplier;
        this.sourceCatalogListener = sourceCatalogListener;
    }

    @Override
    public Source newInstance(TableReplication tableReplication) {
        boolean snapshotsDisabled = true;
        if (tableReplication.getReplicationMode() == ReplicationMode.FULL) {
            snapshotsDisabled = this.sourceCatalog.isDisableSnapshots();
        }
        return new Source(this.sourceCatalog, this.sourceHiveConf, this.sourceMetaStoreClientSupplier, this.sourceCatalogListener, snapshotsDisabled, tableReplication.getSourceTable().getTableLocation());
    }
}

