/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.transformation;

import com.hotels.bdp.circustrain.api.conf.TransformOptions;
import com.hotels.bdp.circustrain.api.event.EventTableReplication;
import com.hotels.bdp.circustrain.api.event.TableReplicationListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTableParametersTransformation
implements TableReplicationListener {
    private final Map<String, String> tableParameters = new HashMap<String, String>();
    private Map<String, String> tableParametersOverride;

    protected AbstractTableParametersTransformation(TransformOptions transformOptions) {
        if (transformOptions.getTransformOptions() == null) {
            return;
        }
        Object tableParameters = transformOptions.getTransformOptions().get("table-properties");
        if (tableParameters instanceof Map) {
            this.tableParameters.putAll((Map)tableParameters);
        }
    }

    protected Map<String, String> getTableParameters() {
        if (this.tableParametersOverride != null && !this.tableParametersOverride.isEmpty()) {
            return this.tableParametersOverride;
        }
        return this.tableParameters;
    }

    public void tableReplicationStart(EventTableReplication tableReplication, String eventId) {
        this.tableParametersOverride = Collections.emptyMap();
        Map transformOptions = tableReplication.getTransformOptions();
        if (transformOptions == null) {
            return;
        }
        Object tableParametersOverride = transformOptions.get("table-properties");
        if (tableParametersOverride instanceof Map) {
            this.tableParametersOverride = (Map)tableParametersOverride;
        }
    }

    public void tableReplicationSuccess(EventTableReplication tableReplication, String eventId) {
    }

    public void tableReplicationFailure(EventTableReplication tableReplication, String eventId, Throwable t) {
    }
}

