/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.transformation;

import com.hotels.bdp.circustrain.api.conf.TransformOptions;
import com.hotels.bdp.circustrain.api.metadata.TableTransformation;
import com.hotels.bdp.circustrain.core.transformation.AbstractTableParametersTransformation;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Table;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"replication"})
@Component
public final class TableParametersTransformation
extends AbstractTableParametersTransformation
implements TableTransformation {
    @Autowired
    public TableParametersTransformation(TransformOptions transformOptions) {
        super(transformOptions);
    }

    public Table transform(Table table) {
        Map<String, String> tableParameters = this.getTableParameters();
        if (tableParameters == null || tableParameters.isEmpty()) {
            return table;
        }
        tableParameters = this.mergeTableParameters(tableParameters, table);
        table.setParameters(tableParameters);
        return table;
    }

    private Map<String, String> mergeTableParameters(Map<String, String> tableParameters, Table table) {
        LinkedHashMap<String, String> parameters = table.getParameters() != null ? new LinkedHashMap(table.getParameters()) : new LinkedHashMap<String, String>();
        parameters.putAll(tableParameters);
        return parameters;
    }
}

