/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.core.util;

import com.google.common.base.Joiner;
import com.hotels.bdp.circustrain.core.util.JarPathResolver;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibJarDeployer {
    private static final Logger LOG = LoggerFactory.getLogger(LibJarDeployer.class);

    public void libjars(Configuration conf, Class<?> ... targetClasses) throws IOException {
        String libjarsList = this.createLibJarList(targetClasses);
        conf.set("tmpjars", this.validateFiles(libjarsList, conf), "from -libjars command line option");
        URL[] libjars = GenericOptionsParser.getLibJars((Configuration)conf);
        if (libjars != null && libjars.length > 0) {
            AccessController.doPrivileged(new PriviledgedClassLoader(conf, libjars));
        }
    }

    private String createLibJarList(Class<?> ... targetClasses) {
        HashSet<URI> jarUris = new HashSet<URI>();
        for (Class<?> targetClass : targetClasses) {
            URI jarUri = JarPathResolver.PROTECTION_DOMAIN.getPath(targetClass);
            LOG.debug("Found libjar for '{}' at '{}'", targetClass, (Object)jarUri);
            jarUris.add(jarUri);
        }
        String libjarsList = Joiner.on((char)',').join(jarUris);
        return libjarsList;
    }

    private String validateFiles(String files, Configuration conf) throws IOException {
        if (files == null) {
            return null;
        }
        String[] fileArr = files.split(",");
        if (fileArr.length == 0) {
            throw new IllegalArgumentException("File name can't be empty string");
        }
        String[] finalArr = new String[fileArr.length];
        for (int i = 0; i < fileArr.length; ++i) {
            String finalPath;
            URI pathURI;
            String tmp = fileArr[i];
            if (tmp.isEmpty()) {
                throw new IllegalArgumentException("File name can't be empty string");
            }
            try {
                pathURI = new URI(tmp);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            Path path = new Path(pathURI);
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
            if (pathURI.getScheme() == null) {
                if (!localFs.exists(path)) {
                    throw new FileNotFoundException("File " + tmp + " does not exist.");
                }
                finalPath = path.makeQualified(localFs.getUri(), localFs.getWorkingDirectory()).toString();
            } else {
                FileSystem fs = path.getFileSystem(conf);
                if (!fs.exists(path)) {
                    throw new FileNotFoundException("File " + tmp + " does not exist.");
                }
                finalPath = path.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString();
            }
            finalArr[i] = finalPath;
        }
        return StringUtils.arrayToString((String[])finalArr);
    }

    private static class PriviledgedClassLoader
    implements PrivilegedAction<Void> {
        private final Configuration conf;
        private final URL[] libjars;

        public PriviledgedClassLoader(Configuration conf, URL[] libjars) {
            this.conf = conf;
            this.libjars = libjars;
        }

        @Override
        public Void run() {
            this.conf.setClassLoader((ClassLoader)new URLClassLoader(this.libjars, this.conf.getClassLoader()));
            Thread.currentThread().setContextClassLoader(new URLClassLoader(this.libjars, Thread.currentThread().getContextClassLoader()));
            return null;
        }
    }
}

