/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.extension;

import com.google.common.annotations.VisibleForTesting;
import com.hotels.bdp.circustrain.extension.ExtensionPackageProvider;
import com.hotels.bdp.circustrain.extension.PropertyExtensionPackageProvider;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class ExtensionInitializer
implements ApplicationContextInitializer<AnnotationConfigApplicationContext> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionInitializer.class);
    private final ExtensionPackageProvider provider;

    public ExtensionInitializer() {
        this(new PropertyExtensionPackageProvider());
    }

    @VisibleForTesting
    ExtensionInitializer(ExtensionPackageProvider provider) {
        this.provider = provider;
    }

    public void initialize(AnnotationConfigApplicationContext context) {
        Set<String> packageNames = this.provider.getPackageNames(context.getEnvironment());
        if (packageNames.size() > 0) {
            LOG.info("Adding packageNames '{}' to component scan.", packageNames);
            context.scan(packageNames.toArray(new String[packageNames.size()]));
        }
    }
}

