/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.bdp.circustrain.manifest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestAttributes {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestAttributes.class);
    static final String META_INF_MANIFEST_MF = "META-INF/MANIFEST.MF";
    private static final String JAR_PROTOCOL = "jar:";
    private static final String FILE_PROTOCOL = "file:";
    private final String attributesString;
    private Attributes attributes = new Attributes();

    public ManifestAttributes(Class<?> mainClass) {
        this(mainClass.getProtectionDomain());
    }

    ManifestAttributes(ProtectionDomain protectionDomain) {
        StringBuilder attributesStringBuilder = new StringBuilder();
        try (InputStream manifestStream = this.openManifestStream(protectionDomain);){
            if (manifestStream != null) {
                this.attributes = new Manifest(manifestStream).getMainAttributes();
                for (Map.Entry<Object, Object> entry : this.attributes.entrySet()) {
                    attributesStringBuilder.append(entry.getKey() + "=" + entry.getValue() + "; ");
                }
            } else {
                attributesStringBuilder.append("Could not find Manifest via " + protectionDomain);
            }
        }
        catch (NullPointerException e) {
            LOG.warn("No Manifest found", (Throwable)e);
            attributesStringBuilder.append("No Manifest found");
        }
        catch (Exception e) {
            LOG.warn("Error getting manifest", (Throwable)e);
            attributesStringBuilder.append("Error getting manifest " + e.getMessage());
        }
        this.attributesString = attributesStringBuilder.toString();
    }

    public String getAttribute(String name) {
        return this.attributes.getValue(new Attributes.Name(name));
    }

    protected InputStream openManifestStream(ProtectionDomain protectionDomain) throws MalformedURLException, IOException {
        URL manifestUrl = null;
        manifestUrl = this.selectManifestFromJars(protectionDomain);
        LOG.debug("Manifest location in JARs is {}", (Object)manifestUrl);
        if (manifestUrl == null) {
            manifestUrl = this.selectFromFileLocation(protectionDomain);
            LOG.debug("Manifest location on disk is {}", (Object)manifestUrl);
        }
        if (manifestUrl == null) {
            manifestUrl = protectionDomain.getClassLoader().getResource(META_INF_MANIFEST_MF);
            LOG.debug("Manifest location via getResource() is {}", (Object)manifestUrl);
        }
        if (manifestUrl == null) {
            LOG.warn("Manifest not found!");
            return null;
        }
        return manifestUrl.openStream();
    }

    private URL selectManifestFromJars(ProtectionDomain protectionDomain) throws IOException {
        URL jarLocation = protectionDomain.getCodeSource().getLocation();
        if (jarLocation != null) {
            String containingJar = JAR_PROTOCOL + jarLocation.toString();
            Enumeration<URL> resources = protectionDomain.getClassLoader().getResources(META_INF_MANIFEST_MF);
            if (resources != null) {
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    if (!url.toString().startsWith(containingJar)) continue;
                    LOG.debug("Found a manifest in location {}", (Object)url);
                    return url;
                }
            }
        }
        return null;
    }

    private URL selectFromFileLocation(ProtectionDomain protectionDomain) throws IOException {
        String location = protectionDomain.getCodeSource().getLocation().getFile();
        location = FILE_PROTOCOL + location + "/" + META_INF_MANIFEST_MF;
        URL url = new URL(location);
        File manifestFile = new File(url.getFile());
        if (manifestFile.exists()) {
            return url;
        }
        LOG.debug("Could not find manifest in location {}", (Object)location);
        return null;
    }

    public String toString() {
        return this.attributesString;
    }
}

