/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.hcommon.hive.metastore.client.closeable;

import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import com.hotels.hcommon.hive.metastore.client.api.MetaStoreClientFactory;
import com.hotels.hcommon.hive.metastore.client.closeable.Hive12CompatibleMetaStoreClientFactory;
import com.hotels.hcommon.hive.metastore.exception.MetaStoreClientException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseableMetaStoreClientFactory
implements MetaStoreClientFactory {
    private static final Logger log = LoggerFactory.getLogger(CloseableMetaStoreClientFactory.class);
    private final Hive12CompatibleMetaStoreClientFactory hive12CompatibleClientFactory = new Hive12CompatibleMetaStoreClientFactory();

    @Override
    public CloseableMetaStoreClient newInstance(HiveConf hiveConf, String name) {
        log.info("Connecting to '{}' metastore at '{}'", (Object)name, (Object)hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS));
        try {
            return this.hive12CompatibleClientFactory.newInstance(RetryingMetaStoreClient.getProxy((HiveConf)hiveConf, (HiveMetaHookLoader)new HiveMetaHookLoader(){

                public HiveMetaHook getHook(Table tbl) throws MetaException {
                    return null;
                }
            }, (String)HiveMetaStoreClient.class.getName()));
        }
        catch (RuntimeException | MetaException e) {
            String message = String.format("Unable to connect to '%s' metastore at '%s'", name, hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS));
            throw new MetaStoreClientException(message, e);
        }
    }
}

