/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.hcommon.hive.metastore.client.closeable;

import com.hotels.hcommon.hive.metastore.compatibility.HiveMetaStoreClientCompatibility;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.thrift.TApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CloseableMetaStoreClientInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(CloseableMetaStoreClientInvocationHandler.class);
    private final IMetaStoreClient delegate;
    private final HiveMetaStoreClientCompatibility compatibility;

    CloseableMetaStoreClientInvocationHandler(IMetaStoreClient delegate, HiveMetaStoreClientCompatibility compatibility) {
        this.delegate = delegate;
        this.compatibility = compatibility;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)this.delegate, args);
        }
        catch (InvocationTargetException e) {
            try {
                log.info("Couldn't invoke method {}", (Object)method.toGenericString());
                if (this.compatibility != null && e.getCause().getClass().isAssignableFrom(TApplicationException.class)) {
                    log.info("Attempting to invoke with {}", (Object)this.compatibility.getClass().getName());
                    return this.invokeCompatibility(method, args);
                }
            }
            catch (Throwable t) {
                log.warn("Unable to run compatibility for metastore client method {}. Will rethrow original exception: ", (Object)method.getName(), (Object)t);
            }
            throw e.getCause();
        }
    }

    private Object invokeCompatibility(Method method, Object[] args) throws Throwable {
        Class<?>[] argTypes = CloseableMetaStoreClientInvocationHandler.getTypes(args);
        Method compatibilityMethod = this.compatibility.getClass().getMethod(method.getName(), argTypes);
        return compatibilityMethod.invoke((Object)this.compatibility, args);
    }

    private static Class<?>[] getTypes(Object[] args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        return argTypes;
    }
}

