/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.hcommon.hive.metastore.client.closeable;

import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import com.hotels.hcommon.hive.metastore.client.closeable.CloseableMetaStoreClientInvocationHandler;
import com.hotels.hcommon.hive.metastore.compatibility.HiveMetaStoreClientCompatibility;
import com.hotels.hcommon.hive.metastore.compatibility.HiveMetaStoreClientCompatibility12x;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Hive12CompatibleMetaStoreClientFactory {
    private static final Logger log = LoggerFactory.getLogger(Hive12CompatibleMetaStoreClientFactory.class);

    Hive12CompatibleMetaStoreClientFactory() {
    }

    CloseableMetaStoreClient newInstance(IMetaStoreClient delegate) {
        HiveMetaStoreClientCompatibility12x compatibility = null;
        try {
            compatibility = new HiveMetaStoreClientCompatibility12x(delegate);
        }
        catch (Throwable t) {
            log.warn("Unable to initialize compatibility", t);
        }
        return this.newInstance(delegate, compatibility);
    }

    CloseableMetaStoreClient newInstance(IMetaStoreClient delegate, HiveMetaStoreClientCompatibility compatibility) {
        ClassLoader classLoader = CloseableMetaStoreClient.class.getClassLoader();
        Class[] interfaces = new Class[]{CloseableMetaStoreClient.class};
        CloseableMetaStoreClientInvocationHandler handler = new CloseableMetaStoreClientInvocationHandler(delegate, compatibility);
        return (CloseableMetaStoreClient)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler);
    }
}

