/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.hcommon.hive.metastore.client.tunnelling;

import com.hotels.hcommon.ssh.validation.constraint.TunnelRoute;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.NotBlank;

public class MetastoreTunnel {
    private static final int DEFAULT_PORT = 22;
    private static final String DEFAULT_LOCALHOST = "localhost";
    private static final int DEFAULT_TIMEOUT_MILLIS = 60000;
    @NotBlank
    @TunnelRoute
    private String route;
    @Min(value=1L)
    @Max(value=65535L)
    private int port = 22;
    private String localhost = "localhost";
    @NotBlank
    private String privateKeys;
    @NotBlank
    private String knownHosts;
    @Min(value=0L)
    private int timeout = 60000;
    @Pattern(regexp="yes|no", flags={Pattern.Flag.CASE_INSENSITIVE}, message="StrictHostKeyChecking can be set to 'yes' or 'no'")
    private String strictHostKeyChecking = "yes";

    public String getRoute() {
        return this.route;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getLocalhost() {
        return this.localhost;
    }

    public void setLocalhost(String localhost) {
        this.localhost = localhost;
    }

    public String getPrivateKeys() {
        return this.privateKeys;
    }

    public void setPrivateKeys(String privateKeys) {
        this.privateKeys = privateKeys;
    }

    public String getKnownHosts() {
        return this.knownHosts;
    }

    public void setKnownHosts(String knownHosts) {
        this.knownHosts = knownHosts;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getStrictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    public void setStrictHostKeyChecking(String strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
    }

    public boolean isStrictHostKeyCheckingEnabled() {
        return "yes".equalsIgnoreCase(this.strictHostKeyChecking);
    }
}

