/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.hcommon.hive.metastore.client.tunnelling;

import com.google.common.base.Supplier;
import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import com.hotels.hcommon.hive.metastore.client.api.MetaStoreClientFactory;
import com.hotels.hcommon.hive.metastore.client.supplier.HiveMetaStoreClientSupplier;
import com.hotels.hcommon.hive.metastore.exception.MetaStoreClientException;
import com.hotels.hcommon.ssh.MethodChecker;
import com.hotels.hcommon.ssh.SshException;
import com.hotels.hcommon.ssh.TunnelableFactory;
import com.hotels.hcommon.ssh.TunnelableSupplier;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import javax.validation.constraints.NotNull;
import org.apache.hadoop.hive.conf.HiveConf;

public class TunnellingMetaStoreClientSupplier
implements Supplier<CloseableMetaStoreClient> {
    private final HiveConf hiveConf;
    private final String name;
    private final String localHost;
    private final String remoteHost;
    private final int remotePort;
    private final TunnelableFactory<CloseableMetaStoreClient> tunnelableFactory;
    private final MetaStoreClientFactory metaStoreClientFactory;

    TunnellingMetaStoreClientSupplier(@NotNull HiveConf hiveConf, @NotNull String name, @NotNull String localHost, @NotNull MetaStoreClientFactory metaStoreClientFactory, @NotNull TunnelableFactory<CloseableMetaStoreClient> tunnelableFactory) {
        URI metaStoreUri;
        this.hiveConf = hiveConf;
        this.name = name;
        this.tunnelableFactory = tunnelableFactory;
        try {
            metaStoreUri = new URI(hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.remoteHost = metaStoreUri.getHost();
        this.remotePort = metaStoreUri.getPort();
        this.localHost = localHost;
        this.metaStoreClientFactory = metaStoreClientFactory;
    }

    public CloseableMetaStoreClient get() {
        try {
            int localPort = TunnellingMetaStoreClientSupplier.getLocalPort();
            HiveConf localHiveConf = TunnellingMetaStoreClientSupplier.localHiveConf(this.hiveConf, this.localHost, localPort);
            HiveMetaStoreClientSupplier supplier = new HiveMetaStoreClientSupplier(this.metaStoreClientFactory, localHiveConf, this.name);
            return (CloseableMetaStoreClient)this.tunnelableFactory.wrap((TunnelableSupplier)supplier, MethodChecker.DEFAULT, this.localHost, localPort, this.remoteHost, this.remotePort);
        }
        catch (Exception e) {
            throw new MetaStoreClientException("Unable to create tunnelled HiveMetaStoreClient", e);
        }
    }

    private static HiveConf localHiveConf(HiveConf hiveConf, String localHost, int localPort) {
        HiveConf localHiveConf = new HiveConf(hiveConf);
        String proxyMetaStoreUris = "thrift://" + localHost + ":" + localPort;
        localHiveConf.setVar(HiveConf.ConfVars.METASTOREURIS, proxyMetaStoreUris);
        return localHiveConf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getLocalPort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException | RuntimeException e) {
            throw new SshException("Unable to bind to a free localhost port", (Throwable)e);
        }
    }
}

