/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.hcommon.hive.metastore.client.tunnelling;

import com.hotels.hcommon.hive.metastore.client.api.CloseableMetaStoreClient;
import com.hotels.hcommon.hive.metastore.client.api.MetaStoreClientFactory;
import com.hotels.hcommon.hive.metastore.client.tunnelling.TunnellingMetaStoreClientSupplier;
import com.hotels.hcommon.ssh.SshSettings;
import com.hotels.hcommon.ssh.TunnelableFactory;
import org.apache.hadoop.hive.conf.HiveConf;

public class TunnellingMetaStoreClientSupplierBuilder {
    private static final int DEFAULT_PORT = 22;
    private static final String DEFAULT_LOCALHOST = "localhost";
    private static final int DEFAULT_SESSION_TIMEOUT = 60000;
    private static final boolean DEFAULT_STRICT_HOST_KEY_CHECK = true;
    private String localHost = "localhost";
    private int sshPort = 22;
    private int timeout = 60000;
    private boolean strictHostKeyChecking = true;
    private String name;
    private String sshRoute;
    private String privateKeys;
    private String knownHosts;

    public TunnellingMetaStoreClientSupplier build(HiveConf hiveConf, MetaStoreClientFactory metaStoreClientFactory) {
        return this.build(hiveConf, metaStoreClientFactory, SshSettings.builder().withRoute(this.sshRoute).withSshPort(this.sshPort).withPrivateKeys(this.privateKeys).withKnownHosts(this.knownHosts).withSessionTimeout(this.timeout).withStrictHostKeyChecking(this.strictHostKeyChecking).build());
    }

    private TunnellingMetaStoreClientSupplier build(HiveConf hiveConf, MetaStoreClientFactory metaStoreClientFactory, SshSettings sshSettings) {
        return this.build(hiveConf, metaStoreClientFactory, (TunnelableFactory<CloseableMetaStoreClient>)new TunnelableFactory(sshSettings));
    }

    private TunnellingMetaStoreClientSupplier build(HiveConf hiveConf, MetaStoreClientFactory metaStoreClientFactory, TunnelableFactory<CloseableMetaStoreClient> tunnelableFactory) {
        return new TunnellingMetaStoreClientSupplier(hiveConf, this.name, this.localHost, metaStoreClientFactory, tunnelableFactory);
    }

    public TunnellingMetaStoreClientSupplierBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public TunnellingMetaStoreClientSupplierBuilder withRoute(String sshRoute) {
        this.sshRoute = sshRoute;
        return this;
    }

    public TunnellingMetaStoreClientSupplierBuilder withPort(int sshPort) {
        this.sshPort = sshPort;
        return this;
    }

    public TunnellingMetaStoreClientSupplierBuilder withPrivateKeys(String privateKeys) {
        this.privateKeys = privateKeys;
        return this;
    }

    public TunnellingMetaStoreClientSupplierBuilder withKnownHosts(String knownHosts) {
        this.knownHosts = knownHosts;
        return this;
    }

    public TunnellingMetaStoreClientSupplierBuilder withLocalHost(String localHost) {
        this.localHost = localHost;
        return this;
    }

    public TunnellingMetaStoreClientSupplierBuilder withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public TunnellingMetaStoreClientSupplierBuilder withStrictHostKeyChecking(String strictHostKeyChecking) {
        this.strictHostKeyChecking = "true".equals(strictHostKeyChecking) || "yes".equals(strictHostKeyChecking);
        return this;
    }
}

