/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.hcommon.hive.metastore.compatibility;

import com.hotels.hcommon.hive.metastore.compatibility.HiveMetaStoreClientCompatibility;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;

public class HiveMetaStoreClientCompatibility12x
implements HiveMetaStoreClientCompatibility {
    private final TServiceClient tServiceClient;

    public HiveMetaStoreClientCompatibility12x(IMetaStoreClient client) {
        while (Proxy.isProxyClass(client.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(client);
            if (handler.getClass().isAssignableFrom(RetryingMetaStoreClient.class)) {
                client = (IMetaStoreClient)HiveMetaStoreClientCompatibility12x.getField(handler, "base");
                continue;
            }
            throw new RuntimeException("Unknown InvocationHandler " + handler.getClass());
        }
        this.tServiceClient = (TServiceClient)HiveMetaStoreClientCompatibility12x.getField(client, "client");
    }

    private static <T> T getField(Object object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            Object result = null;
            if (field.isAccessible()) {
                result = field.get(object);
            } else {
                field.setAccessible(true);
                result = field.get(object);
                field.setAccessible(false);
            }
            return (T)result;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to hack client", e);
        }
    }

    private static Table deepCopy(Table table) {
        return table.deepCopy();
    }

    private void sendBase(String methodName, TBase<?, ?> args) throws TException {
        try {
            Method sendBase = TServiceClient.class.getDeclaredMethod("sendBase", String.class, TBase.class);
            sendBase.setAccessible(true);
            sendBase.invoke((Object)this.tServiceClient, methodName, args);
            sendBase.setAccessible(false);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Unable to hack sendBase", e);
        }
    }

    private void receiveBase(TBase<?, ?> result, String methodName) throws TException {
        try {
            Method receiveBase = TServiceClient.class.getDeclaredMethod("receiveBase", TBase.class, String.class);
            receiveBase.setAccessible(true);
            receiveBase.invoke((Object)this.tServiceClient, result, methodName);
            receiveBase.setAccessible(false);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Unable to hack receiveBase", e);
        }
    }

    @Override
    public Table getTable(String dbname, String name) throws MetaException, TException, NoSuchObjectException {
        return HiveMetaStoreClientCompatibility12x.deepCopy(this.get_table(dbname, name));
    }

    private Table get_table(String dbname, String tbl_name) throws MetaException, NoSuchObjectException, TException {
        this.send_get_table(dbname, tbl_name);
        return this.recv_get_table();
    }

    private void send_get_table(String dbname, String tbl_name) throws TException {
        ThriftHiveMetastore.get_table_args args = new ThriftHiveMetastore.get_table_args();
        args.setDbname(dbname);
        args.setTbl_name(tbl_name);
        this.sendBase("get_table", (TBase<?, ?>)args);
    }

    private Table recv_get_table() throws MetaException, NoSuchObjectException, TException {
        ThriftHiveMetastore.get_table_result result = new ThriftHiveMetastore.get_table_result();
        this.receiveBase((TBase<?, ?>)result, "get_table");
        if (result.isSetSuccess()) {
            return result.getSuccess();
        }
        if (result.getO1() != null) {
            throw result.getO1();
        }
        if (result.getO2() != null) {
            throw result.getO2();
        }
        throw new TApplicationException(5, "get_table failed: unknown result");
    }
}

