/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.hcommon.hive.metastore.conf;

import com.google.common.collect.Sets;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveConfFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HiveConfFactory.class);
    private final List<String> resources;
    private final Map<String, String> properties;
    static final Set<String> SECRET_KEYS = Sets.newHashSet((Object[])new String[]{"fs.s3.awsAccessKeyId", "fs.s3.awsSecretAccessKey", "fs.s3n.awsAccessKeyId", "fs.s3n.awsSecretAccessKey", "fs.s3a.access.key", "fs.s3a.secret.key"});

    public HiveConfFactory(List<String> resources, Map<String, String> properties) {
        this.resources = resources;
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveConf newInstance() {
        Class<HiveConf> clazz = HiveConf.class;
        synchronized (HiveConf.class) {
            HiveConf conf;
            if (this.resources != null) {
                URL hiveSiteLocation = HiveConf.getHiveSiteLocation();
                HiveConf.setHiveSiteLocation(null);
                conf = new HiveConf(new Configuration(false), this.getClass());
                HiveConf.setHiveSiteLocation((URL)hiveSiteLocation);
                for (String resource : this.resources) {
                    LOG.debug("Adding custom resource: {}", (Object)resource);
                    conf.addResource(resource);
                }
            } else {
                conf = new HiveConf(new Configuration(true), this.getClass());
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (this.properties != null) {
                for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                    LOG.debug("Adding custom property: {}={}", (Object)entry.getKey(), (Object)this.hideSecrets(entry.getKey(), entry.getValue()));
                    conf.set(entry.getKey(), entry.getValue());
                }
            }
            return conf;
        }
    }

    private String hideSecrets(String key, String value) {
        if (SECRET_KEYS.contains(key)) {
            return "****";
        }
        return value;
    }
}

