/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.hcommon.hive.metastore.iterator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchResolver {
    private static final Logger LOG = LoggerFactory.getLogger(BatchResolver.class);
    private final List<String> names;
    private final short batchSize;

    BatchResolver(List<String> names, short batchSize) {
        this.names = names;
        this.batchSize = batchSize;
    }

    List<List<String>> resolve() throws MetaException, TException {
        if (this.names.size() <= this.batchSize) {
            LOG.debug("Number of partitions ({}) is less than batch size ({}).", (Object)this.names.size(), (Object)this.batchSize);
            return Collections.singletonList(this.names);
        }
        ArrayList<List<String>> partitionValueBounds = new ArrayList<List<String>>(this.names.size() / this.batchSize + 1);
        int n = this.names.size();
        for (int i = 0; i < this.names.size(); i += this.batchSize) {
            partitionValueBounds.add(this.names.subList(i, Math.min(n, i + this.batchSize)));
        }
        return partitionValueBounds;
    }
}

