/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.hcommon.hive.metastore.iterator;

import com.hotels.hcommon.hive.metastore.iterator.BatchResolver;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionIterator
implements Iterator<Partition> {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionIterator.class);
    private static final short NO_LIMIT = -1;
    private final Iterator<List<String>> partitionNames;
    private final IMetaStoreClient metastore;
    private final Table table;
    private final Ordering ordering;
    private int count;
    private Iterator<Partition> batch;

    private static List<String> loadPartitionNames(IMetaStoreClient metastore, Table table, Ordering ordering) throws MetaException, TException {
        LOG.debug("Fetching all partition names.");
        List names = metastore.listPartitionNames(table.getDbName(), table.getTableName(), (short)-1);
        if (ordering == Ordering.REVERSE) {
            Collections.reverse(names);
        }
        LOG.debug("Fetched {} partition names for table {}.", (Object)names.size(), (Object)Warehouse.getQualifiedName((Table)table));
        return names;
    }

    public PartitionIterator(IMetaStoreClient metastore, Table table, short batchSize) throws MetaException, TException {
        this(metastore, table, batchSize, Ordering.NATURAL);
    }

    public PartitionIterator(IMetaStoreClient metastore, Table table, short batchSize, Ordering ordering) throws MetaException, TException {
        this(metastore, table, new BatchResolver(PartitionIterator.loadPartitionNames(metastore, table, ordering), batchSize), ordering);
    }

    public PartitionIterator(IMetaStoreClient metastore, Table table, short batchSize, List<String> partitionNames) throws MetaException, TException {
        this(metastore, table, new BatchResolver(partitionNames, batchSize), Ordering.NATURAL);
    }

    public PartitionIterator(IMetaStoreClient metastore, Table table, short batchSize, List<String> partitionNames, Ordering ordering) throws MetaException, TException {
        this(metastore, table, new BatchResolver(partitionNames, batchSize), ordering);
    }

    PartitionIterator(IMetaStoreClient metastore, Table table, BatchResolver batchResolver, Ordering ordering) throws MetaException, TException {
        this.ordering = ordering;
        this.partitionNames = batchResolver.resolve().iterator();
        this.batch = Collections.emptyList().iterator();
        this.table = table;
        this.metastore = metastore;
    }

    @Override
    public boolean hasNext() {
        if (this.batch.hasNext()) {
            return true;
        }
        if (this.partitionNames.hasNext()) {
            List<String> names = this.partitionNames.next();
            try {
                List partitions = this.metastore.getPartitionsByNames(this.table.getDbName(), this.table.getTableName(), names);
                if (this.ordering == Ordering.REVERSE) {
                    Collections.reverse(partitions);
                }
                this.count += partitions.size();
                LOG.debug("Retrieved {} partitions, total: {}.", (Object)partitions.size(), (Object)this.count);
                this.batch = partitions.iterator();
            }
            catch (TException e) {
                throw new RuntimeException(e);
            }
        }
        return this.batch.hasNext();
    }

    @Override
    public Partition next() {
        return this.batch.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    public static enum Ordering {
        NATURAL,
        REVERSE;

    }
}

