/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.hcommon.hive.metastore.util;

import com.google.common.base.Strings;
import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

public final class LocationUtils {
    private LocationUtils() {
    }

    public static boolean hasLocation(Table table) {
        return table.getSd() != null && !Strings.isNullOrEmpty((String)table.getSd().getLocation());
    }

    public static boolean hasLocation(Partition partition) {
        return partition.getSd() != null && !Strings.isNullOrEmpty((String)partition.getSd().getLocation());
    }

    public static URI locationAsUri(Table table) {
        return LocationUtils.locationAsPath(table).toUri();
    }

    public static URI locationAsUri(Partition partition) {
        return LocationUtils.locationAsPath(partition).toUri();
    }

    public static Path locationAsPath(Table table) {
        return new Path(table.getSd().getLocation());
    }

    public static Path locationAsPath(Partition partition) {
        return new Path(partition.getSd().getLocation());
    }
}

