/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.road.partition;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import lombok.NonNull;

class JsonNodeHashCodeFunction
implements Function<JsonNode, Integer> {
    @NonNull
    private final Random random;

    @Override
    public Integer apply(JsonNode node) {
        return Optional.of(node).filter(n -> !n.isMissingNode()).map(Objects::hashCode).orElse(this.random.nextInt());
    }

    @ConstructorProperties(value={"random"})
    JsonNodeHashCodeFunction(@NonNull Random random) {
        if (random == null) {
            throw new NullPointerException("random is marked @NonNull but is null");
        }
        this.random = random;
    }
}

