/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.road.partition;

import com.google.common.base.CharMatcher;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class KeyPathParser {
    private static final CharMatcher FIRST_VALUE_CHAR_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.is((char)'_'));
    private static final CharMatcher VALUE_CHAR_MATCHER = FIRST_VALUE_CHAR_MATCHER.or(CharMatcher.is((char)'-'));

    public static Path parse(String path) {
        int i;
        String string = path = path == null ? "" : path.trim();
        if (path.length() < 1) {
            throw new IllegalArgumentException("Empty or null input");
        }
        ArrayList elements = new ArrayList();
        StringBuilder value = new StringBuilder();
        State state = State.START;
        char[] chars = path.toCharArray();
        for (i = 0; i < chars.length; ++i) {
            state = state.next(chars[i], i, elements, value);
        }
        if ((state = state.next('\u0000', i, elements, value)) != State.EOF) {
            throw new ParsingException("Unexpected end of file");
        }
        return new Path(Collections.unmodifiableList(elements));
    }

    private static void flushRoot(List<Element> e, StringBuilder v) {
        e.add(RootElement.INSTANCE);
        v.setLength(0);
    }

    private static void flushUnquoted(List<Element> e, StringBuilder v) {
        e.add(new IdElement(v.toString(), "." + v.toString()));
        v.setLength(0);
    }

    private static void flushQuoted(List<Element> e, StringBuilder v) {
        e.add(new IdElement(v.toString(), "[\"" + v.toString() + "\"]"));
        v.setLength(0);
    }

    static /* synthetic */ CharMatcher access$200() {
        return FIRST_VALUE_CHAR_MATCHER;
    }

    static /* synthetic */ CharMatcher access$300() {
        return VALUE_CHAR_MATCHER;
    }

    static enum RootElement implements Element
    {
        INSTANCE;


        @Override
        public boolean isRoot() {
            return true;
        }

        @Override
        public String id() {
            return "$";
        }

        public String toString() {
            return this.id();
        }
    }

    static class IdElement
    implements Element {
        private final String id;
        private final String captured;

        @Override
        public boolean isRoot() {
            return false;
        }

        @Override
        public String id() {
            return this.id;
        }

        public String toString() {
            return this.captured;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IdElement)) {
                return false;
            }
            IdElement other = (IdElement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.id;
            String other$id = other.id;
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$captured = this.captured;
            String other$captured = other.captured;
            return !(this$captured == null ? other$captured != null : !this$captured.equals(other$captured));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IdElement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.id;
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $captured = this.captured;
            result = result * 59 + ($captured == null ? 43 : $captured.hashCode());
            return result;
        }

        @ConstructorProperties(value={"id", "captured"})
        public IdElement(String id, String captured) {
            this.id = id;
            this.captured = captured;
        }
    }

    public static class Path {
        private final List<Element> elements;

        private Path(List<Element> elements) {
            this.elements = elements;
        }

        public List<Element> elements() {
            return this.elements;
        }

        public String toString() {
            return this.elements.stream().map(e -> e.toString()).collect(Collectors.joining(""));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Path)) {
                return false;
            }
            Path other = (Path)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Element> this$elements = this.elements;
            List<Element> other$elements = other.elements;
            return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Path;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Element> $elements = this.elements;
            result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
            return result;
        }
    }

    public static interface Element {
        public boolean isRoot();

        public String id();
    }

    public static class ParsingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        ParsingException(String expected, int i, char c) {
            this("Expected " + expected + " at position " + i + " but got '" + c + "'");
        }

        ParsingException(String message) {
            super(message);
        }
    }

    @FunctionalInterface
    static interface NextState {
        public State next(char var1, int var2, List<Element> var3, StringBuilder var4);
    }

    static enum State {
        START(CharMatcher.none()),
        ROOT(CharMatcher.is((char)'$')),
        OPEN_PAREN(CharMatcher.is((char)'[')),
        CLOSE_PAREN(CharMatcher.is((char)']')),
        OPEN_QUOTE(CharMatcher.is((char)'\"')),
        CLOSE_QUOTE(CharMatcher.is((char)'\"')),
        DOT(CharMatcher.is((char)'.')),
        FIRST_UNQUOTED_VALUE(KeyPathParser.access$200()),
        UNQUOTED_VALUE(KeyPathParser.access$300()),
        FIRST_QUOTED_VALUE(KeyPathParser.access$300().or(CharMatcher.is((char)'.'))),
        QUOTED_VALUE(KeyPathParser.access$300().or(CharMatcher.is((char)'.'))),
        END_VALUE(CharMatcher.none()),
        EOF(CharMatcher.is((char)'\u0000'));

        private final CharMatcher charMatcher;
        private NextState nextState;

        private State(CharMatcher charMatcher) {
            this.charMatcher = charMatcher;
        }

        private boolean matches(char c) {
            return this.charMatcher.matches(c);
        }

        private State next(char c, int i, List<Element> e, StringBuilder v) {
            return this.nextState.next(c, i, e, v);
        }

        static {
            State.START.nextState = (c, i, e, v) -> {
                if (ROOT.matches(c)) {
                    KeyPathParser.flushRoot(e, v);
                    return END_VALUE;
                }
                throw new ParsingException("'$'", i, c);
            };
            State.END_VALUE.nextState = (c, i, e, v) -> {
                if (DOT.matches(c)) {
                    return DOT;
                }
                if (OPEN_PAREN.matches(c)) {
                    return OPEN_PAREN;
                }
                if (EOF.matches(c)) {
                    return EOF;
                }
                throw new ParsingException("'.' or '['", i, c);
            };
            State.OPEN_PAREN.nextState = (c, i, e, v) -> {
                if (OPEN_QUOTE.matches(c)) {
                    return OPEN_QUOTE;
                }
                throw new ParsingException("'\"'", i, c);
            };
            State.OPEN_QUOTE.nextState = (c, i, e, v) -> {
                if (FIRST_QUOTED_VALUE.matches(c)) {
                    v.append(c);
                    return FIRST_QUOTED_VALUE;
                }
                throw new ParsingException("[a-zA-Z0-9_-] or '.'", i, c);
            };
            State.QUOTED_VALUE.nextState = State.FIRST_QUOTED_VALUE.nextState = (c, i, e, v) -> {
                if (QUOTED_VALUE.matches(c)) {
                    v.append(c);
                    return QUOTED_VALUE;
                }
                if (CLOSE_QUOTE.matches(c)) {
                    KeyPathParser.flushQuoted(e, v);
                    return CLOSE_QUOTE;
                }
                throw new ParsingException("[a-zA-Z0-9_-], '.' or '\"'", i, c);
            };
            State.CLOSE_QUOTE.nextState = (c, i, e, v) -> {
                if (CLOSE_PAREN.matches(c)) {
                    return END_VALUE;
                }
                throw new ParsingException("[a-zA-Z0-9_-], '.' or '\"'", i, c);
            };
            State.DOT.nextState = (c, i, e, v) -> {
                if (FIRST_UNQUOTED_VALUE.matches(c)) {
                    v.append(c);
                    return UNQUOTED_VALUE;
                }
                throw new ParsingException("[a-zA-Z0-9_]", i, c);
            };
            State.UNQUOTED_VALUE.nextState = (c, i, e, v) -> {
                if (UNQUOTED_VALUE.matches(c)) {
                    v.append(c);
                    return UNQUOTED_VALUE;
                }
                if (DOT.matches(c)) {
                    KeyPathParser.flushUnquoted(e, v);
                    return DOT;
                }
                if (OPEN_PAREN.matches(c)) {
                    KeyPathParser.flushUnquoted(e, v);
                    return OPEN_PAREN;
                }
                if (EOF.matches(c)) {
                    KeyPathParser.flushUnquoted(e, v);
                    return EOF;
                }
                throw new ParsingException("[a-zA-Z0-9_-] or '.'", i, c);
            };
        }
    }
}

