/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.road.partition;

import com.hotels.road.exception.InvalidKeyPathException;
import com.hotels.road.partition.KeyPathParser;
import java.util.List;
import org.apache.avro.Schema;

public class KeyPathValidator {
    private final Schema rootSchema;
    private final KeyPathParser.Path path;

    public KeyPathValidator(KeyPathParser.Path path, Schema schema) {
        this.path = path;
        this.rootSchema = schema;
    }

    public void validate() throws InvalidKeyPathException {
        List<KeyPathParser.Element> elements = this.path.elements();
        this.validateElement(elements, this.rootSchema, elements.get(0).toString());
    }

    private void validateElement(List<KeyPathParser.Element> elements, Schema schema, String location) throws InvalidKeyPathException {
        if (elements.size() == 1) {
            return;
        }
        switch (schema.getType()) {
            case RECORD: {
                this.validateRecordElement(elements, schema, location);
                break;
            }
            case UNION: {
                this.validateUnionElement(elements, schema, location);
                break;
            }
            default: {
                throw new InvalidKeyPathException(String.format("Element '%s' not a traversable type (found '%s'), in path: %s", location, schema.getType(), this.path));
            }
        }
    }

    private void validateUnionElement(List<KeyPathParser.Element> elements, Schema schema, String location) throws InvalidKeyPathException {
        int unionIndex = 0;
        for (Schema unionBranch : schema.getTypes()) {
            this.validateElement(elements, unionBranch, location + "(UnionIndex:" + unionIndex + ")");
            ++unionIndex;
        }
    }

    private void validateRecordElement(List<KeyPathParser.Element> elements, Schema schema, String location) throws InvalidKeyPathException {
        String fieldName = elements.get(1).id();
        Schema.Field field = schema.getField(fieldName);
        if (field == null) {
            throw new InvalidKeyPathException(String.format("Field '%s' does not exist in record located at '%s' in path: %s", fieldName, location, this.path));
        }
        this.validateElement(this.allButFirst(elements), field.schema(), location + elements.get(1).toString());
    }

    private List<KeyPathParser.Element> allButFirst(List<KeyPathParser.Element> elements) {
        return elements.subList(1, elements.size());
    }
}

