/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.road.partition;

import com.fasterxml.jackson.databind.JsonNode;
import com.hotels.road.partition.JsonNodeHashCodeFunction;
import com.hotels.road.partition.KeyPathParser;
import com.hotels.road.partition.PartitionNodeFunction;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;

public class MessageHashCodeFunctionSupplier
implements Supplier<Function<JsonNode, Integer>>,
AutoCloseable {
    @NonNull
    private final Supplier<KeyPathParser.Path> partitionPathSupplier;
    @NonNull
    private final Random random;

    public MessageHashCodeFunctionSupplier(Supplier<KeyPathParser.Path> partitionPathSupplier) {
        this(partitionPathSupplier, new Random());
    }

    @Override
    public Function<JsonNode, Integer> get() {
        return Optional.ofNullable(this.partitionPathSupplier.get()).map(path -> new PartitionNodeFunction((KeyPathParser.Path)path).andThen(new JsonNodeHashCodeFunction(this.random))).orElse(path -> this.random.nextInt());
    }

    @Override
    public void close() throws Exception {
        if (this.partitionPathSupplier instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.partitionPathSupplier)).close();
        }
    }

    @ConstructorProperties(value={"partitionPathSupplier", "random"})
    public MessageHashCodeFunctionSupplier(@NonNull Supplier<KeyPathParser.Path> partitionPathSupplier, @NonNull Random random) {
        if (partitionPathSupplier == null) {
            throw new NullPointerException("partitionPathSupplier is marked @NonNull but is null");
        }
        if (random == null) {
            throw new NullPointerException("random is marked @NonNull but is null");
        }
        this.partitionPathSupplier = partitionPathSupplier;
        this.random = random;
    }
}

