/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.road.truck.park.avro;

import java.util.Optional;
import org.apache.avro.file.CodecFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan
public class AvroConfiguration {
    @Bean
    CodecFactory codecFactory(@Value(value="${avroCodec.name:deflate}") String codecName, @Value(value="${avroCodec.level:3}") String compressionLevel) {
        switch (codecName) {
            case "deflate": {
                return CodecFactory.deflateCodec((int)this.level(compressionLevel, -1));
            }
            case "xz": {
                return CodecFactory.xzCodec((int)this.level(compressionLevel, 6));
            }
        }
        return CodecFactory.fromString((String)codecName);
    }

    private int level(String level, int defaultLevel) {
        return Optional.ofNullable(level).map(Integer::parseInt).orElse(defaultLevel);
    }
}

