/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.road.truck.park.avro;

import com.hotels.road.truck.park.spi.RecordWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

public class AvroRecordWriter
implements RecordWriter {
    private final DataFileWriter<GenericData.Record> writer;

    AvroRecordWriter(Schema schema, OutputStream outputStream, CodecFactory codecFactory) throws IOException {
        this.writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));
        this.writer.setCodec(codecFactory);
        this.writer.create(schema, outputStream);
    }

    public void write(GenericData.Record record) throws IOException {
        this.writer.append((Object)record);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    @Component
    public static class Factory
    implements RecordWriter.Factory {
        private final CodecFactory codecFactory;

        @Autowired
        public Factory(CodecFactory codecFactory) {
            this.codecFactory = codecFactory;
        }

        public RecordWriter create(Schema schema, OutputStream outputStream) throws IOException {
            return new AvroRecordWriter(schema, outputStream, this.codecFactory);
        }
    }
}

