/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.support.api;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;

public final class FakeHttpServer {
    private final String appId;
    private final String originId;
    private final HttpsSettings httpsSettings;
    private final int serverPort;
    private final int adminPort;
    private final WireMockServer server;

    private FakeHttpServer(String appId, String originId, WireMockConfiguration wireMockConfiguration) {
        this.appId = appId;
        this.originId = originId;
        this.httpsSettings = wireMockConfiguration.httpsSettings();
        this.server = new WireMockServer((Options)wireMockConfiguration);
        if (this.httpsSettings.enabled()) {
            this.adminPort = wireMockConfiguration.portNumber();
            this.serverPort = this.httpsSettings.port();
        } else {
            this.adminPort = wireMockConfiguration.portNumber();
            this.serverPort = wireMockConfiguration.portNumber();
        }
    }

    public FakeHttpServer(int port) {
        this("generic-app", "generic-app-" + port, WireMockConfiguration.wireMockConfig().port(port));
    }

    public static FakeHttpServer newHttpServer(int port) {
        return new FakeHttpServer(port);
    }

    public static FakeHttpServer newHttpServer(String appId, String originId, WireMockConfiguration wireMockConfiguration) {
        return new FakeHttpServer(appId, originId, wireMockConfiguration);
    }

    public FakeHttpServer start() {
        WireMock.configureFor((String)"localhost", (int)this.adminPort);
        if (!this.server.isRunning()) {
            this.server.start();
        }
        return this;
    }

    public FakeHttpServer stub(UrlMatchingStrategy urlMatchingStrategy, ResponseDefinitionBuilder response) {
        WireMock.configureFor((String)"localhost", (int)this.adminPort());
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlMatchingStrategy)urlMatchingStrategy).willReturn(response));
        return this;
    }

    public FakeHttpServer stub(MappingBuilder mappingBuilder, ResponseDefinitionBuilder response) {
        WireMock.configureFor((String)"localhost", (int)this.adminPort());
        WireMock.stubFor((MappingBuilder)mappingBuilder.willReturn(response));
        return this;
    }

    public void verify(int count, RequestPatternBuilder builder) {
        WireMock.configureFor((String)"localhost", (int)this.adminPort());
        WireMock.verify((int)count, (RequestPatternBuilder)builder);
    }

    public void verify(RequestPatternBuilder builder) {
        WireMock.configureFor((String)"localhost", (int)this.adminPort());
        WireMock.verify((RequestPatternBuilder)builder);
    }

    public FakeHttpServer stop() {
        WireMock.configureFor((String)"localhost", (int)this.adminPort());
        if (this.server.isRunning()) {
            this.server.stop();
        }
        return this;
    }

    public FakeHttpServer reset() {
        WireMock.configureFor((String)"localhost", (int)this.adminPort());
        WireMock.reset();
        return this;
    }

    public String appId() {
        return this.appId;
    }

    public String originId() {
        return this.originId;
    }

    public int port() {
        return this.serverPort;
    }

    public int adminPort() {
        return this.adminPort;
    }

    public boolean ssl() {
        return this.httpsSettings.enabled();
    }

    public FakeHttpServer setDelay(int delay) {
        WireMock.configureFor((String)"localhost", (int)this.adminPort());
        WireMock.setGlobalFixedDelay((int)delay);
        return this;
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    static {
        System.setProperty("org.mortbay.log.class", "com.github.tomakehurst.wiremock.jetty.LoggerAdapter");
    }
}

