/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.support.api.matchers;

import com.hotels.styx.api.HttpHeader;
import com.hotels.styx.api.HttpHeaderNames;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class HeaderMatcher
extends TypeSafeMatcher<HttpHeader> {
    private final CharSequence name;
    private final Matcher<String> value;

    public static Matcher<HttpHeader> header(CharSequence name, Matcher<String> matcher) {
        return new HeaderMatcher(name, matcher);
    }

    public static Matcher<HttpHeader> header(CharSequence name, String value) {
        return new HeaderMatcher(name, (Matcher<String>)Matchers.is((Object)value));
    }

    public static Matcher<HttpHeader> contentType(String value) {
        return new HeaderMatcher(HttpHeaderNames.CONTENT_TYPE, (Matcher<String>)Matchers.is((Object)value));
    }

    public static Matcher<HttpHeader> cacheControl(String value) {
        return new HeaderMatcher("Cache-Control", (Matcher<String>)Matchers.is((Object)value));
    }

    public static Matcher<HttpHeader> header(HttpHeader header) {
        return new HeaderMatcher(header.name(), (Matcher<String>)Matchers.is((Object)header.value()));
    }

    private HeaderMatcher(CharSequence name, Matcher<String> value) {
        this.name = name;
        this.value = value;
    }

    public boolean matchesSafely(HttpHeader actual) {
        return actual.name().equalsIgnoreCase(this.name.toString()) && this.value.matches((Object)actual.value());
    }

    public void describeTo(Description description) {
        description.appendText("header ").appendValue((Object)this.name).appendText(" with value of ");
        this.value.describeTo(description);
    }
}

