/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.support.api.matchers;

import com.google.common.collect.Iterables;
import com.hotels.styx.api.HttpHeader;
import com.hotels.styx.support.api.matchers.HeaderMatcher;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsCollectionContaining;

public class HttpHeadersMatcher
extends TypeSafeMatcher<Iterable<HttpHeader>> {
    private static final String START = HttpHeadersMatcher.lineSeparator();
    private static final String END = HttpHeadersMatcher.lineSeparator();
    private final List<Matcher<HttpHeader>> matchers;

    public static Matcher<Iterable<HttpHeader>> isNotCacheable() {
        return new HttpHeadersMatcher(Arrays.asList(HeaderMatcher.header((CharSequence)"Pragma", "no-cache"), HeaderMatcher.header((CharSequence)"Expires", "Mon, 1 Jan 2007 08:00:00 GMT"), HeaderMatcher.header((CharSequence)"Cache-Control", "no-cache,must-revalidate,no-store")));
    }

    public static Matcher<Iterable<HttpHeader>> hasHeaders(Matcher<HttpHeader> ... matchers) {
        return new HttpHeadersMatcher(Arrays.asList(matchers));
    }

    public HttpHeadersMatcher(List<Matcher<HttpHeader>> matchers) {
        this.matchers = matchers;
    }

    public boolean matchesSafely(Iterable<HttpHeader> actual) {
        return Iterables.all(this.matchers, elementMatcher -> new IsCollectionContaining(elementMatcher).matches((Object)actual));
    }

    public void describeTo(Description description) {
        description.appendText("headers to contain").appendText(HttpHeadersMatcher.lineSeparator()).appendList(START, String.format(" and %s%s", HttpHeadersMatcher.lineSeparator(), " "), END, this.matchers);
    }

    private static String lineSeparator() {
        return System.getProperty("line.separator");
    }
}

